/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.event.data.SwitchCity;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.EViewState;
import ch.sahits.game.graphic.display.dialog.util.DialogFactory;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.gameplay.internal.PolygonInitializerFactory;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.graphic.image.ImageScaleState;
import ch.sahits.game.graphic.image.model.ImageData;
import ch.sahits.game.graphic.javafx.display.BaseMainGameImageView;
import ch.sahits.game.graphic.javafx.display.DisplayMessageOverlay;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.MainGameImageView;
import ch.sahits.game.graphic.javafx.display.SceneEventHandlerFactory;
import ch.sahits.game.graphic.javafx.display.SeamapImageView;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DialogCloseing;
import ch.sahits.game.openpatrician.annotation.DialogOpening;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.dialog.Dialog;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.spring.DependentAnnotationConfigApplicationContext;
import ch.sahits.game.openpatrician.spring.DialogScope;
import ch.sahits.game.openpatrician.util.IRebinabable;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@UniquePrototype
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class MainGameView
extends Group
implements IDialogContoller,
IRebinabable {
    private static final Logger logger = LogManager.getLogger(MainGameView.class);
    public static final int MINMIMAL_DISPLAY_HEIGHT = 766;
    private double controlWidth;
    private double controlHeight;
    @Autowired
    private IImageUtilities imageUtils;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private IDataImageLoader xmlLoader;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private DialogFactory dialogFactory;
    private Rectangle placeHolder;
    private BaseMainGameImageView imgView;
    private Dialog dialog;
    @Autowired
    private DialogScope dialogScope;
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    @Autowired
    private SceneEventHandlerFactory sceneEventHandlerFactory;
    @Autowired
    private PolygonInitializerFactory polygonInitFactory;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private DisplayMessageOverlay dispMesgOverlay;
    @Autowired
    private DependentAnnotationConfigApplicationContext context;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    private IMap map;
    private StackPane stack;
    private SeamapImageView seaMapView;

    public MainGameView(double width, double heigth) {
        this.setManaged(false);
        this.controlWidth = width;
        this.controlHeight = heigth;
    }

    @PostConstruct
    private void createComponents() {
        this.setUpImageView();
        this.sceneEventHandlerFactory.currentSceneProperty().bindBidirectional(this.currentScene);
        this.sceneEventHandlerFactory.setUpDialogController(this);
        this.polygonInitFactory.currentSceneProperty().bindBidirectional(this.currentScene);
        this.stack = new StackPane();
        this.stack.getChildren().add((Object)this.imgView);
        this.placeHolder = new Rectangle(this.controlWidth, this.controlHeight);
        this.placeHolder.setFill((Paint)Color.BLACK);
        this.dispMesgOverlay.setLayoutY(10.0);
        this.dispMesgOverlay.setLayoutX(10.0);
        this.getChildren().addAll((Object[])new Node[]{this.placeHolder, this.stack, this.dispMesgOverlay});
        this.clientEventBus.register((Object)this);
        this.setOnMouseClicked(event -> {
            IGame game = this.gameFactory.getGame();
            game.normalSpeed();
        });
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
    }

    private String getImageNameFromScene() {
        switch ((EScene)((Object)this.currentScene.get())) {
            case MARKET: {
                return "images/scene/marketPlaceScene";
            }
            case PORT: {
                return "images/scene/portScene";
            }
            case SHIPYARD: {
                return "images/scene/shipYard";
            }
            case TAVERN: {
                return "images/scene/tavernIterior";
            }
            case CITY_HALL: {
                return "images/scene/cityhall";
            }
            case LOANER: {
                return "images/scene/loaner";
            }
            case CHURCH: {
                return "images/scene/churchInterior";
            }
        }
        throw new RuntimeException(this.currentScene.get() + " is not implemented");
    }

    private void setUpImageView() {
        String imageName = this.getImageNameFromScene();
        Image tmpImg = this.xmlLoader.getImage(imageName);
        ImageData imgData = this.xmlLoader.getImageData(imageName);
        Dimension2D targetDim = new Dimension2D(this.controlWidth, this.controlHeight);
        ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
        logger.debug("State of the port scene before: " + state);
        this.imgView = new MainGameImageView(this.controlWidth, this.controlHeight, this.imageUtils.cropAndScale(imageName, state), state);
        List<Polygon> polygons = this.polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
        this.imgView.resetPolygons(polygons);
        if (this.seaMapView != null) {
            this.seaMapView.setDisplayed(false);
        }
        this.viewState.setState(EViewState.CITY);
        logger.debug("State of the port scene after : " + state);
    }

    private void setUpSeamapImageView() {
        IHumanPlayer player = this.viewState.getPlayer();
        Image mapImage = this.imageUtils.createMapWithCities(this.map, (IPlayer)player);
        Dimension2D origDim = new Dimension2D(mapImage.getWidth(), mapImage.getHeight());
        double scale = this.controlHeight / origDim.getHeight();
        Dimension2D targetDim = new Dimension2D(origDim.getWidth() * scale, origDim.getHeight() * scale);
        mapImage = this.imageUtils.scale(mapImage, targetDim, scale);
        Point2D coordinates = this.viewState.getCurrentCityProxy().get().getCity().getCoordinates();
        coordinates = new Point2D(coordinates.getX() * scale, coordinates.getY() * scale);
        if (this.seaMapView == null) {
            this.seaMapView = (SeamapImageView)((Object)this.context.getBean("seamapImageView", new Object[]{mapImage, this.controlWidth, this.controlHeight, coordinates, scale}));
        } else {
            this.seaMapView.resetImage(mapImage, this.controlWidth, this.controlHeight, scale);
        }
        this.seaMapView.setDisplayed(true);
        this.imgView = this.seaMapView;
        this.viewState.setState(EViewState.MAP);
    }

    public void widthChange(double oldWidth, double newWidth) {
        List<Polygon> polygons = new ArrayList<Polygon>();
        if (this.imgView instanceof MainGameImageView) {
            String imageName = this.getImageNameFromScene();
            Image tmpImg = this.xmlLoader.getImage(imageName);
            ImageData imgData = this.xmlLoader.getImageData(imageName);
            Dimension2D targetDim = new Dimension2D(newWidth, this.controlHeight);
            ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
            ImageView tmpImgView = this.imageUtils.cropAndScale(imageName, state);
            ((MainGameImageView)this.imgView).setImageView(newWidth, this.controlHeight, tmpImgView, state);
            polygons = this.polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
        }
        if (this.imgView instanceof SeamapImageView) {
            IHumanPlayer player = this.viewState.getPlayer();
            Image mapImage = this.imageUtils.createMapWithCities(this.map, (IPlayer)player);
            Dimension2D origDim = new Dimension2D(mapImage.getWidth(), mapImage.getHeight());
            double scale = this.controlHeight / origDim.getHeight();
            Dimension2D targetDim = new Dimension2D(origDim.getWidth() * scale, origDim.getHeight() * scale);
            mapImage = this.imageUtils.scale(mapImage, targetDim, scale);
            ((SeamapImageView)this.imgView).resetImage(mapImage, newWidth, this.controlHeight, scale);
        }
        this.imgView.resetPolygons(polygons);
        this.placeHolder.setWidth(newWidth);
        this.controlWidth = newWidth;
    }

    public void heightChange(double oldHeight, double newHeigth) {
        List<Polygon> polygons = new ArrayList<Polygon>();
        if (this.imgView instanceof MainGameImageView) {
            String imageName = this.getImageNameFromScene();
            Image tmpImg = this.xmlLoader.getImage(imageName);
            ImageData imgData = this.xmlLoader.getImageData(imageName);
            Dimension2D targetDim = new Dimension2D(this.controlWidth, newHeigth);
            ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
            ImageView tmpImgView = this.imageUtils.cropAndScale(imageName, state);
            ((MainGameImageView)this.imgView).setImageView(this.controlWidth, newHeigth, tmpImgView, state);
            polygons = this.polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
        }
        if (this.imgView instanceof SeamapImageView) {
            IHumanPlayer player = this.viewState.getPlayer();
            Image mapImage = this.imageUtils.createMapWithCities(this.map, (IPlayer)player);
            Dimension2D origDim = new Dimension2D(mapImage.getWidth(), mapImage.getHeight());
            double scale = newHeigth / origDim.getHeight();
            Dimension2D targetDim = new Dimension2D(origDim.getWidth() * scale, origDim.getHeight() * scale);
            mapImage = this.imageUtils.scale(mapImage, targetDim, scale);
            ((SeamapImageView)this.imgView).resetImage(mapImage, this.controlWidth, newHeigth, scale);
        }
        this.imgView.resetPolygons(polygons);
        this.placeHolder.setHeight(newHeigth);
        this.controlHeight = newHeigth;
    }

    @Subscribe
    public void handleViewChange(ViewChangeEvent event) {
        if (event.getAddresse().equals(MainGameView.class)) {
            if (event.getEventNotice() instanceof DialogTemplate) {
                this.setNewDialog((DialogTemplate)event.getEventNotice());
            } else if (event.getEventNotice() instanceof ViewChangeCityPlayerProxyJFX && ((ViewChangeCityPlayerProxyJFX)event.getEventNotice()).getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_SEA_MAP) {
                this.currentScene.set((Object)EScene.SEAMAP);
                this.changeScene();
            } else {
                this.sceneEventHandlerFactory.getSceneEventHandler().handleEvent(event.getEventNotice());
            }
        }
    }

    @Override
    public void replaceDialog(EDialogType dialogType, Object ... params) {
        this.closeDialog();
        while (this.dialog != null) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setNewDialog(dialogType, params);
    }

    @Override
    @DialogCloseing
    public void closeDialog() {
        if (Platform.isFxApplicationThread()) {
            this.closeDialogUnwrapped();
        } else {
            Platform.runLater(() -> this.closeDialogUnwrapped());
        }
    }

    private void closeDialogUnwrapped() {
        if (this.dialog != null) {
            this.dialog.close();
            this.context.removePrototypeBean((Object)this.dialog);
            this.getChildren().remove((Object)this.dialog);
            this.dialog = null;
            this.dialogScope.closeScope();
        } else {
            logger.warn("Tried to close the dialog but it was already null");
        }
    }

    @Override
    @DialogOpening
    public void setNewDialog(EDialogType dialogType, Object ... params) {
        if (params.length == 0) {
            this.dialog = this.dialogFactory.getDialog(dialogType, this.viewState.getCurrentCityProxy().get());
        } else if (params.length == 2) {
            if (params[0] instanceof IConvoy && params[1] instanceof IShip) {
                this.dialog = this.dialogFactory.getDialog(dialogType, this.viewState.getCurrentCityProxy().get(), (IConvoy)params[0], (IShip)params[1]);
            } else {
                throw new IllegalArgumentException("Cannot handle parameters " + params[0] + " and " + params[1]);
            }
        }
        this.dialog.setDialogType(dialogType);
        this.setNewDialog();
    }

    @Override
    @DialogOpening
    public void setNewDialog(DialogTemplate template) {
        this.dialog = this.dialogFactory.getDialog(template);
        this.setNewDialog();
    }

    private void setNewDialog() {
        this.dialogScope.openScope();
        this.dialog.setLayoutX((this.controlWidth - 518.0) / 2.0);
        this.dialog.setLayoutY((this.controlHeight - 691.0) / 2.0);
        if (Platform.isFxApplicationThread()) {
            this.getChildren().add((Object)this.dialog);
        } else {
            Platform.runLater(() -> {
                if (this.dialog != null) {
                    this.getChildren().add((Object)this.dialog);
                }
            });
        }
    }

    @Override
    public void changeScene() {
        if (Platform.isFxApplicationThread()) {
            this.changeSceneUnwrapped();
        } else {
            Platform.runLater(() -> this.changeSceneUnwrapped());
        }
    }

    private void changeSceneUnwrapped() {
        this.closeDialog();
        this.stack.getChildren().removeAll((Object[])new Node[]{this.imgView});
        if (this.currentScene.get() == EScene.SEAMAP) {
            this.setUpSeamapImageView();
        } else {
            this.setUpImageView();
        }
        this.stack.getChildren().add((Object)this.imgView);
    }

    public void rebind() {
        if (this.currentScene.get() != EScene.PORT) {
            ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_PORT);
            this.handleViewChange(new ViewChangeEvent(MainGameView.class, (Object)proxy));
        }
        if (this.seaMapView != null) {
            this.seaMapView.removeShipIcons();
        }
    }

    @Subscribe
    public void handleSwitchToCity(SwitchCity event) {
        this.currentScene.set((Object)EScene.PORT);
        this.changeScene();
    }

    public Dialog getDialog() {
        return this.dialog;
    }
}

