package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Apr 06, 2015
 */
@Prototype
@ClassCategory(EClassCategory.HANDLER)
public class ViewChangeDialogTemplateRunnable implements Runnable {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    private final DialogTemplate template;

    public ViewChangeDialogTemplateRunnable(DialogTemplate template) {
        Preconditions.checkNotNull(template, "The template must be defined");
        this.template = template;
    }
    @Override
    public void run() {
            clientEventBus.post(new ViewChangeEvent(MainGameView.class, template));
    }
}
