package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.javafx.control.BarrelIconView;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.binding.StringBinding;
import javafx.scene.Group;
import javafx.scene.image.ImageView;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * Dialog for trading between the city and the ship.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 23, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class CityShipTradeDialog extends BaseTradeDialog {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

	public CityShipTradeDialog(ICityPlayerProxyJFX city) {
		super(city, EDialogType.PORT_CITY_TO_SHIP);
	}


	@Override
	protected Group createSubTitle(final ICityPlayerProxyJFX city) {
		StringBinding cityPopulation = new StringBinding() {
			{
				super.bind(city.getCity().getPopulationBinding());
			}
			
			@Override
			protected String computeValue() {
				ICity actualCity = city.getCity();
				return actualCity.getName()+" "+actualCity.getPopulationBinding().asString().get();
			}
		};
		Text cityText = new Text();
		cityText.textProperty().bind(cityPopulation);
		cityText.getStyleClass().add("dialogText");
		Group g = new Group();
		g.setManaged(false);
		
		final INavigableVessel ship = city.getActiveShip();
		ImageView barrel = new BarrelIconView();
		barrel.setLayoutX(200 - 26);
		barrel.setLayoutY(-12);
		
		StringBinding shipLoad = new StringBinding() {
			
			{
				super.bind(ship.getLoadBinding());
			}
			
			@Override
			protected String computeValue() {
				return ship.getLoadBinding().asString().get()+" / "+ship.getLoadableSpace();
			}
		};
		
		Text shipSpace = new Text();
		shipSpace.textProperty().bind(shipLoad);
		shipSpace.getStyleClass().add("dialogText");
		shipSpace.setLayoutX(200);

		String shipNameLabel = ship.getName();
		if (ship instanceof IConvoy) {
			shipNameLabel = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.convoyName", new Object[]{shipNameLabel}, locale.getCurrentLocal());
		}
		
		Text shipName = new Text(shipNameLabel);
		shipName.setWrappingWidth(160);
		shipName.getStyleClass().add("dialogText");
		shipName.setLayoutX(300);
		
		g.getChildren().addAll(cityText, barrel, shipSpace, shipName);
		return g;
	}


	@Override
	public void executeOnCloseButtonClicked() {
        clientEventBus.post(new NoticeBoardClose());
		super.executeOnCloseButtonClicked();
	}
	
	

}
