package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.control.PaginationV2;
import ch.sahits.game.javafx.control.PaginationV2Builder;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.TextParser;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.geometry.Insets;
import javafx.scene.text.Font;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * Dialog presenting personal data.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 7, 2013
 *
 */
@UniquePrototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class HistoryStandaloneDialog extends CloseButtonDialog {
	private final Logger logger = LogManager.getLogger(getClass());

	/** Reference to the city view model */
	protected final ICityPlayerProxyJFX city;
	private final String historyResource;
	@Autowired
	private MessageSource messageSource;
	@Autowired
	private Locale locale;
	@Autowired
	@Qualifier("resourceReference")
	private MessageSource resources;
	@Autowired
	private TextParser textParser;
	@Autowired
	private IFontLoader fontLoader;

	@Autowired
	private ModelTranslations modelTranslator;

	public HistoryStandaloneDialog( ICityPlayerProxyJFX city, String historyResource) {
		super();
		this.city = city;
		this.historyResource = historyResource;
	}
	@PostConstruct
	private void initializeDialog() {
		final ch.sahits.game.openpatrician.util.model.Text historyText = getHistoryText();
		Insets insets = new Insets(FRAME_BORDER, FRAME_BORDER, FRAME_BORDER, FRAME_BORDER * 2);
		Font headerFont = fontLoader.createDefaultFont(24); // bold font not available
		Font defaultfont = fontLoader.createDefaultFont(18);
		PaginationV2 pagination = PaginationV2Builder.create()
				.backButtonLabel(messageSource.getMessage("ch.sahits.game.graphic.display.scene.CreditsScene.back", new Object[]{}, locale.getCurrentLocal()))
				.nextButtonLabel(messageSource.getMessage("ch.sahits.game.graphic.display.scene.CreditsScene.next", new Object[]{}, locale.getCurrentLocal()))
				.text(historyText)
				.contentMaxWidth(WRAPPING_WIDTH)
				.contentMaxHeight(CloseButtonDialog.CLOSE_BTN_Y_POS - 4 * FRAME_BORDER)
				.padding(insets)
				.navigationLabelFont(defaultfont)
				.headerFont(headerFont)
				.paragraphFont(defaultfont)
				.centeredFont(defaultfont)
				.firstLastPageAction(event -> {
							MainGameView mainGameView = (MainGameView) getParent();
							mainGameView.closeDialog();
						}
				)
				.build();
		pagination.setLayoutY(FRAME_BORDER * 2);

//		getContent().remove(getCloseButton()); // todo: andi 9/26/15: if the close button is removed or hidden the content no longer renders

		getContent().add(pagination);
	}

	/**
	 * Retrieve the history text.
	 * @return
	 */
	private ch.sahits.game.openpatrician.util.model.Text getHistoryText() {
		String resourceName = resources.getMessage(historyResource, new Object[0], locale.getCurrentLocal());
		URL url = getClass().getClassLoader().getResource(resourceName);
		try {
			InputStream is= url.openStream();
			return textParser.parse(is);
		} catch (IOException e) {
			logger.warn("History text could not be found: " + url.toExternalForm());
			return new ch.sahits.game.openpatrician.util.model.Text();
		}
	}

	@Override
	public void executeOnCloseButtonClicked() {
		clientEventBus.post(new NoticeBoardClose());
		super.executeOnCloseButtonClicked();
	}

}
