package ch.sahits.game.graphic.display.dialog.cityhall;

import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.engine.land.city.CityHallEngine;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.cityhall.ECityViolationPunishment;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityWallPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.ICustomsViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IElectionResult;
import ch.sahits.game.openpatrician.model.city.cityhall.IHeadTaxPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.IMilitiaPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.IPirateSupportViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IPlunderTradingOfficesViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ISpecialTaxPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.ISpecialTaxViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Apr 06, 2015
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class MeetingRoomDialog extends CloseButtonDialog {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private CityHallEngine cityHallEngine;
    @Autowired
    private MapService citiesInteractionService;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private DateService dateService;
    @Autowired
    private ModelTranslations modelTranslator;
    private final ICityPlayerProxyJFX city;

    public MeetingRoomDialog(ICityPlayerProxyJFX city) {
        super();
        this.city = city;
        getStylesheets().add(this.getClass().getResource("/styles/base.css").toExternalForm());
        getStyleClass().add("dialog");
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.title", new Object[]{}, locale.getCurrentLocal()));
        ICityHall cityHall = cityHallEngine.findCityHall(city.getCity());
        boolean meetingToday = hasMeetingToday(cityHall);
        if (!meetingToday) {
            VBox content = new VBox();
            String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.noMeeting", new Object[]{}, locale.getCurrentLocal());
            DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
            content.setLayoutX(text.getLayoutX());
            content.setLayoutY(text.getLayoutY());
            content.getChildren().add(text);
            DateTime d = cityHall.getElectionDate();
            template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.mayorElectionDate", new Object[]{modelTranslator.toDisplayString(d)}, locale.getCurrentLocal());
            text = textFactory.createDecoratedText(template, new HashMap<>());
            content.getChildren().add(text);
            if (cityHall.getNextCouncilMeeting().isPresent()) {
                d = cityHall.getNextCouncilMeeting().get();
                template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.councilMeeting", new Object[]{modelTranslator.toDisplayString(d)}, locale.getCurrentLocal());
                text = textFactory.createDecoratedText(template, new HashMap<>());
                content.getChildren().add(text);
            }
            if (cityHall.getAldermanOffice().isPresent()) {
                d = cityHall.getAldermanElectionDate();
                template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.aldermanElectionDate", new Object[]{modelTranslator.toDisplayString(d)}, locale.getCurrentLocal());
                text = textFactory.createDecoratedText(template, new HashMap<>());
                content.getChildren().add(text);
                if (cityHall.getHanseaticMeetingDate().isPresent()) {
                    d = cityHall.getHanseaticMeetingDate().get();
                    template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.hanseaticMeeting", new Object[]{modelTranslator.toDisplayString(d)}, locale.getCurrentLocal());
                    text = textFactory.createDecoratedText(template, new HashMap<>());
                    content.getChildren().add(text);
                }
            }

            getContent().add(content);
        } else {
            VBox content = new VBox();
            DateTime electionDate = cityHall.getElectionDate();
            if (dateService.isToday(electionDate)) {
                String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.mayoralElection", new Object[]{}, locale.getCurrentLocal());
                DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                content.setLayoutX(text.getLayoutX());
                content.setLayoutY(text.getLayoutY());
                content.getChildren().add(text);
                List<ICitizen> candidates = cityHall.getCandidates();
                IElectionResult result = cityHall.getElectionResult().get();
                for (ICitizen candidate : candidates) {
                    text = getCandidateRow(candidate, result);
                    content.getChildren().add(text);
                }
            }
            if (cityHall.getNextCouncilMeeting().isPresent() && dateService.isToday(cityHall.getNextCouncilMeeting().get())) {
                final Optional<ICityPetition> petition1 = cityHall.getPetition();
                ICityPetition petition = petition1.get();
                if (petition instanceof ICityWallPetition) {
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.citywallEnlargement", new Object[]{}, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    content.setLayoutX(text.getLayoutX());
                    content.setLayoutY(text.getLayoutY());
                    content.getChildren().add(text);
                }
                if (petition instanceof IHeadTaxPetition) {
                   double currentTax = cityHall.getTreasury().getCurrentPropertyTax();
                    double newTax = ((IHeadTaxPetition)petition).getNewTaxValue();
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.changeHeadTax", new Object[]{currentTax, newTax}, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    content.setLayoutX(text.getLayoutX());
                    content.setLayoutY(text.getLayoutY());
                    content.getChildren().add(text);
                }
                if (petition instanceof ISpecialTaxPetition) {
                   int value = ((ISpecialTaxPetition)petition).getTaxValue();
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.specialTax", new Object[]{value}, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    content.setLayoutX(text.getLayoutX());
                    content.setLayoutY(text.getLayoutY());
                    content.getChildren().add(text);
                }
                if (petition instanceof IMilitiaPetition) {
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.citymilitiaEnlargement", new Object[]{}, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    content.setLayoutX(text.getLayoutX());
                    content.setLayoutY(text.getLayoutY());
                    content.getChildren().add(text);
                }
                HBox box = new HBox(10);
                OpenPatricianSmallWaxButton yes = new OpenPatricianSmallWaxButton(messageSource.getMessage("yes", new Object[]{}, locale.getCurrentLocal()));
                yes.getStyleClass().add("actionButton");
                yes.setOnAction((evt) -> {
                            cityHall.getBallotResult().get().vote(true);
                            executeOnCloseButtonClicked();
                        }
                );
                OpenPatricianSmallWaxButton no = new OpenPatricianSmallWaxButton(messageSource.getMessage("no", new Object[]{}, locale.getCurrentLocal()));
                no.getStyleClass().add("actionButton");
                no.setOnAction((evt) -> {
                            cityHall.getBallotResult().get().vote(false);
                            executeOnCloseButtonClicked();
                        }
                );
                box.getChildren().addAll(yes, no);
                content.getChildren().add(box);
            }
            if (cityHall.getAldermanOffice().isPresent()) {
                if (dateService.isToday(cityHall.getAldermanElectionDate())) {
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.aldermanElection", new Object[]{}, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    content.setLayoutX(text.getLayoutX());
                    content.setLayoutY(text.getLayoutY());
                    content.getChildren().add(text);
                    List<ICitizen> candidates = cityHall.getAldermanCandidates().getAll();
                    IElectionResult result = cityHall.getElectionResult().get();
                    for (ICitizen candidate : candidates) {
                        text = getCandidateRow(candidate, result);
                        content.getChildren().add(text);

                    }
                }
                if (cityHall.getHanseaticMeetingDate().isPresent() && dateService.isToday(cityHall.getHanseaticMeetingDate().get())) {
                    final IAldermanOffice office = cityHall.getAldermanOffice().get();
                    ICityViolation violation = office.getViolation().get();

                    if (violation instanceof ICustomsViolation) {
                        String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.customsViolation", new Object[]{violation.getCity().getName()}, locale.getCurrentLocal());
                        DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                        content.setLayoutX(text.getLayoutX());
                        content.setLayoutY(text.getLayoutY());
                        content.getChildren().add(text);
                    }
                    if (violation instanceof IPlunderTradingOfficesViolation) {
                        String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.plundering", new Object[]{violation.getCity().getName()}, locale.getCurrentLocal());
                        DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                        content.setLayoutX(text.getLayoutX());
                        content.setLayoutY(text.getLayoutY());
                        content.getChildren().add(text);
                    }
                    if (violation instanceof IPirateSupportViolation) {
                        String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.pirateSupport", new Object[]{violation.getCity().getName()}, locale.getCurrentLocal());
                        DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                        content.setLayoutX(text.getLayoutX());
                        content.setLayoutY(text.getLayoutY());
                        content.getChildren().add(text);
                    }
                    if (violation instanceof ISpecialTaxViolation) {
                        String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.specialTaxViolation", new Object[]{violation.getCity().getName()}, locale.getCurrentLocal());
                        DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                        content.setLayoutX(text.getLayoutX());
                        content.setLayoutY(text.getLayoutY());
                        content.getChildren().add(text);
                    }
                    ECityViolationPunishment punishment = violation.getPunishment();
                    ITreasury otherTreasury = cityHallEngine.findCityHall(violation.getCity()).getTreasury();
                    DecoratedText punishmentText = getPunishment(punishment, otherTreasury);
                    content.getChildren().add(punishmentText);
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.violationAgreement", new Object[]{}, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    content.getChildren().add(text);
                    HBox box = new HBox(10);
                    OpenPatricianSmallWaxButton yes = new OpenPatricianSmallWaxButton(messageSource.getMessage("yes", new Object[]{}, locale.getCurrentLocal()));
                    yes.getStyleClass().add("actionButton");
                    yes.setId("yes");
                    yes.setOnAction((evt) -> {
                                cityHall.getBallotResult().get().vote(true);
                                executeOnCloseButtonClicked();
                            }
                    );
                    OpenPatricianSmallWaxButton no = new OpenPatricianSmallWaxButton(messageSource.getMessage("no", new Object[]{}, locale.getCurrentLocal()));
                    no.getStyleClass().add("actionButton");
                    no.setId("no");
                    no.setOnAction((evt) -> {
                                cityHall.getBallotResult().get().vote(false);
                                executeOnCloseButtonClicked();
                            }
                    );
                    box.getChildren().addAll(yes, no);
                    content.getChildren().add(box);
                }
            }
            getContent().add(content);
        }
    }

    private DecoratedText getPunishment(ECityViolationPunishment punishment, ITreasury otherTreasury) {
        String template;
        int fine;
        switch (punishment) {
            case SMALL_FINE:
                fine = citiesInteractionService.getFine(punishment, otherTreasury);
                template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.AldermanOfficeDialog.smallFine", new Object[]{fine}, locale.getCurrentLocal());
                return textFactory.createDecoratedText(template, new HashMap<>());
            case MEDIUM_FINE:
                fine = citiesInteractionService.getFine(punishment, otherTreasury);
                template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.AldermanOfficeDialog.mediumFine", new Object[]{fine}, locale.getCurrentLocal());
                return textFactory.createDecoratedText(template, new HashMap<>());
            case LARGE_FINE:
                fine = citiesInteractionService.getFine(punishment, otherTreasury);
                template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.AldermanOfficeDialog.largeFine", new Object[]{fine}, locale.getCurrentLocal());
                return textFactory.createDecoratedText(template, new HashMap<>());
            case BLOCKADE:
                template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.AldermanOfficeDialog.boycott", new Object[]{}, locale.getCurrentLocal());
                return textFactory.createDecoratedText(template, new HashMap<>());
        }
        return null;
    }

    private DecoratedText getCandidateRow(ICitizen candidate, IElectionResult result) {
        Object[] args;
        String template;
        DecoratedText text;
        if (candidate instanceof IHumanPlayer) {
            IPlayer p = (IPlayer) candidate;
            args = new Object[]{modelTranslator.getLocalDisplayDistinctArticle(p.isMale(), true), modelTranslator.getLocalDisplayName(p.getCareerLevel()), modelTranslator.getLocalDisplayName(p.getRank()), p.getName()+" "+p.getLastName()};
        } else {
            args = new Object[]{modelTranslator.getLocalDisplayDistinctArticle(true, true), modelTranslator.getLocalDisplayName(EEconomicCareer.SMART), modelTranslator.getLocalDisplayName(candidate.getRank()), candidate.getName()+" "+candidate.getLastName()};
        }
        template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TownInfoNotice.candidate", args, locale.getCurrentLocal());
        text = textFactory.createDecoratedText(template, new HashMap<>());
        text.setOnMouseReleased((evt) -> {
            result.vote(candidate);
            executeOnCloseButtonClicked();
        });
        return text;
    }

    private boolean hasMeetingToday(ICityHall cityHall) {
        return cityHall.getElectionResult().isPresent() || cityHall.getBallotResult().isPresent();
//        DateTime election = cityHall.getElectionDate();
//        if (date.isToday(election)) {
//            return true;
//        }
//        if (cityHall.getNextCouncilMeeting().isPresent()) {
//            if (date.isToday(cityHall.getNextCouncilMeeting().get())) {
//                return true;
//            }
//        }
//        if (cityHall.getAldermanOffice().isPresent()) {
//            if (date.isToday(cityHall.getAldermanElectionDate())) {
//                return true;
//            }
//            if (cityHall.getHanseaticMeetingDate().isPresent()) {
//                if (date.isToday(cityHall.getHanseaticMeetingDate().get())) {
//                    return true;
//                }
//            }
//        }
//        return false;
    }

    /**
     * Update the notice board and close the dialog.
     */
    @Override
    public void executeOnCloseButtonClicked() {
        super.executeOnCloseButtonClicked();
    }


    private StyleableObjectProperty<Font> font;

    public Font getFont() {
        return font == null ? Font.getDefault() : font.get();
    }

    public void setFont(Font font) {
        this.font.set(font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (font == null) {
            font = new SimpleStyleableObjectProperty<Font>(StyleableProperties.FONT, MeetingRoomDialog.this, "font", Font.getDefault());
        }
        return font;
    }

    private static class StyleableProperties {
        private static final CssMetaData<MeetingRoomDialog, Font> FONT =
                new CssMetaData<MeetingRoomDialog, Font>("-fx-font",
                        StyleConverter.getFontConverter(), Font.getDefault()) {
                    @Override
                    public boolean isSettable(MeetingRoomDialog control) {
                        return control.font == null || !control.font.isBound();
                    }

                    @Override
                    public StyleableProperty<Font> getStyleableProperty(MeetingRoomDialog control) {
                        return control.fontProperty();
                    }
                };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        static {
            final List<CssMetaData<? extends Styleable, ?>> styleables =
                    new ArrayList<CssMetaData<? extends Styleable, ?>>(Control.getClassCssMetaData());
            Collections.addAll(styleables,
                    FONT
            );
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }
}
