package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * Event handler for the loaner scene.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jan 03, 2015
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.HANDLER)
public class LoanerSceneEventHandler  implements ISceneEventHandler {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    @ObjectPropertyType(EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    private IDialogContoller dialogContoller; // this instance exists not at startup
    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull(dialogContoller, "Dialog controller must be initialized first");
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
            ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX) eventNotice;
            // Scene change market place
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_PORT) {
                clientEventBus.post(new NoticeBoardClose());
                currentScene.set(EScene.PORT);
                dialogContoller.changeScene();
            }

        }
        if (eventNotice instanceof EDialogType) {
            dialogContoller.replaceDialog((EDialogType) eventNotice);
        }
    }
}
