package ch.sahits.game.graphic.service;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.clientserverinterface.service.PathInterpolator;
import ch.sahits.game.openpatrician.engine.sea.IPathConverter;
import ch.sahits.game.openpatrician.model.sea.TravellingVessels;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * Converts a list of point into a shape that can be used as path.
 * This algorithm uses straigt lines.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jan 05, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class LinePathConverter implements IPathConverter {
    @Autowired
    private TravellingVessels vessels;
    /**
     * Create a path shape out of a list of points.
     * When the path is created the vessel will be added to the
     * TravellingVessels container.
     * @param vessel vessel that is traveling the path.
     * @param pointedPath input points.
     * @param scale scaling that is used on the path due to the sacle of the map.
     * @return shape representing a path.
     */
    public Path createPath(INavigableVessel vessel, List<Point2D> pointedPath, double scale) {
        Path path = new Path();
        path.setStroke(Color.RED);
        path.setStrokeWidth(2);
        if (!pointedPath.isEmpty()) {
            Point2D p = pointedPath.get(0);
            MoveTo moveTo = new MoveTo();
            moveTo.setX(p.getX() * scale);
            moveTo.setY(p.getY() * scale);
            path.getElements().add(moveTo);
            for (int i = 1; i < pointedPath.size(); i++) {
                p = pointedPath.get(i);
                LineTo lineTo = new LineTo();
                lineTo.setX(p.getX() * scale);
                lineTo.setY(p.getY() * scale);
                path.getElements().add(lineTo);
            }
        }
        vessels.addVessel(vessel, path, pointedPath, false);
        return path;
    }

    /**
     * {@inheritDoc}
     * No actual reduction of points happens.
     * @param initialPoints list of initial points
     * @return
     */
    @Override
    public List<Point2D> reduceLinePoints(List<Point2D> initialPoints) {
        return initialPoints;
    }

    /**
     * No real implementation here.
     * @param vessel that is traveling
     * @param interpolator used to hold the path information
     * @param fraction value between [0,1]. 1 means that the whole distance is traveled.
     * @return
     */
    @Override
    public long calculateDuration(INavigableVessel vessel, PathInterpolator interpolator, double fraction) {
        return 0;
    }
}
