/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.cityhall;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.land.city.CityEngine;
import ch.sahits.game.openpatrician.engine.land.city.CityHallEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHallNotice;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class PublicNoticeDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    private Date date;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private CityEngine cityEngine;
    @Autowired
    private CityHallEngine cityHallEngine;
    @Autowired
    private ClientViewState viewState;
    @ListType(value=ICityHallNotice.class)
    private ObservableList<ICityHallNotice> notices;
    private final IntegerProperty currentIndex = new SimpleIntegerProperty(0);
    private BooleanBinding enablePreviousNext;
    private final ICityPlayerProxyJFX city;
    private StyleableObjectProperty<Font> font;

    public PublicNoticeDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        ICityHall cityHall = this.cityHallEngine.findCityHall(this.city.getCity());
        this.notices = cityHall.getNotices();
        this.enablePreviousNext = new BooleanBinding(){

            protected boolean computeValue() {
                return PublicNoticeDialog.this.notices.size() > 1;
            }
        };
        this.setupCurrentContent();
        int actionButtonX = 197;
        OpenPatricianSmallWaxButton previous = new OpenPatricianSmallWaxButton("<");
        previous.getStyleClass().add((Object)"actionButton");
        previous.setLayoutX(131.0);
        previous.setLayoutY(579.0);
        previous.setOnAction(this.createPreviousAction());
        previous.setDisable(this.notices.size() <= 1);
        OpenPatricianSmallWaxButton next = new OpenPatricianSmallWaxButton(">");
        next.getStyleClass().add((Object)"actionButton");
        next.setLayoutX(325.0);
        next.setLayoutY(579.0);
        next.setOnAction(this.createNextAction());
        next.setDisable(this.notices.size() <= 1);
        OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()));
        action.getStyleClass().add((Object)"actionButton");
        action.setOnAction(this.getAction());
        action.setLayoutX(197.0);
        action.setLayoutY(603.0);
        this.enablePreviousNext.addListener((observableValue, oldVBoolean, newValue) -> {
            next.setDisable(newValue == false);
            previous.setDisable(newValue == false);
        });
        this.getContent().addAll((Object[])new Node[]{previous, next, action});
    }

    private EventHandler<MouseEvent> getAction() {
        return mouseEvent -> {
            ICityHallNotice notice = (ICityHallNotice)this.notices.get(this.currentIndex.get());
            ICity destination = notice.getDestination();
            this.cityEngine.findTavernEngine().getTavernState(destination).setContractBrooker(notice.getContact());
            this.notices.remove((Object)notice);
            if (this.notices.isEmpty()) {
                this.executeOnCloseButtonClicked();
            } else {
                if (this.currentIndex.get() >= this.notices.size()) {
                    this.currentIndex.set(this.currentIndex.get() - 1);
                }
                this.setupCurrentContent();
            }
        };
    }

    private void setupCurrentContent() {
        this.removeDecoratedContent();
        if (this.notices.size() > 0) {
            ICityHallNotice notice = (ICityHallNotice)this.notices.get(this.currentIndex.get());
            EWare ware = (EWare)notice.getRequiredWare();
            ICity destination = notice.getDestination();
            this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.PublicNoticeDialog.title", new Object[]{this.modelTranslator.getLocalDisplayName(ware), destination.getName()}, this.locale.getCurrentLocal()));
            String key = ware.isBarrelSizedWare() ? "ch.sahits.game.graphic.display.dialog.cityhall.PublicNoticeDialog.barrelMessage" : "ch.sahits.game.graphic.display.dialog.cityhall.PublicNoticeDialog.baleMessage";
            AmountablePrice amountPrice = notice.getWareAndAmount();
            DateTime dueDate1 = notice.getDueDate();
            String dueDate = this.modelTranslator.toDisplayString(dueDate1);
            int premium = amountPrice.getAVGPrice() * amountPrice.getAmount();
            Object[] args = new Object[]{this.modelTranslator.getLocalDisplayName(ware), amountPrice.getAmount(), dueDate, premium, amountPrice.getAVGPrice(), 1};
            String template = this.messageSource.getMessage(key, args, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            this.getContent().add((Object)text);
        }
    }

    private EventHandler<MouseEvent> createNextAction() {
        return mouseEvent -> {
            if (this.currentIndex.get() == this.notices.size() - 1) {
                this.currentIndex.set(0);
            } else {
                this.currentIndex.set(this.currentIndex.get() + 1);
            }
            this.setupCurrentContent();
        };
    }

    private EventHandler<MouseEvent> createPreviousAction() {
        return mouseEvent -> {
            if (this.currentIndex.get() == 0) {
                this.currentIndex.set(this.notices.size() - 1);
            } else {
                this.currentIndex.set(this.currentIndex.get() - 1);
            }
            this.setupCurrentContent();
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_BOARD);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return PublicNoticeDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<PublicNoticeDialog, Font> FONT = new CssMetaData<PublicNoticeDialog, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(PublicNoticeDialog control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(PublicNoticeDialog control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

