/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.loaner;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LoanerTakeLoanDialog
extends CloseButtonDialog {
    private final int BUTTON_X = 197;
    private final int BUTTON_Y = 603;
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray; -fx-text-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;  -fx-text-fill: black;";
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private LoanerService loanerService;
    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");
    @ObjectPropertyType(value=ILoanProposal.class)
    private ObjectProperty<ILoanProposal> selectedProposal = new SimpleObjectProperty(null);
    private VBox box;

    public LoanerTakeLoanDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.loaner = (LoanerState)this.loanerService.findLoaner(this.city.getCity());
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.takeLoan", new Object[0], this.locale.getCurrentLocal()));
        String header = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerTakeLoanDialog.dialogSubheading", new Object[0], this.locale.getCurrentLocal());
        this.box = new VBox(5.0);
        this.box.setLayoutX(30.0);
        this.box.setLayoutY(200.0);
        Text subHeading = new Text();
        subHeading.setText(header);
        subHeading.getStyleClass().add((Object)"dialogText");
        this.box.getChildren().add((Object)subHeading);
        for (ILoanProposal proposal : this.loaner.getLoanProposals()) {
            int amount = proposal.getAmount();
            int payback = (int)((double)amount * proposal.getInterest());
            int duration = proposal.getDurationInWeeks();
            String interest = String.format("%.1f", (proposal.getInterest() - 1.0) * 100.0);
            String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerTakeLoanDialog.loanProposal", new Object[]{amount, duration, payback, interest}, this.locale.getCurrentLocal());
            DecoratedText entry = this.textFactory.createDecoratedText(s, new HashMap());
            entry.setOnMouseReleased(mouseEvent -> {
                this.selectedProposal.setValue((Object)proposal);
                this.deactivateAll();
                entry.applyStyle(SELECTED_STYLE);
            });
            entry.applyStyle(DEFAULT_NON_SELECTED_STYLE);
            this.box.getChildren().add((Object)entry);
        }
        OpenPatricianLargeWaxButton acceptBtn = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerTakeLoanDialog.btnLabel", new Object[0], this.locale.getCurrentLocal()));
        acceptBtn.getStyleClass().add((Object)"actionButton");
        acceptBtn.setLayoutX(197.0);
        acceptBtn.setLayoutY(603.0);
        acceptBtn.setDisable(true);
        this.selectedProposal.addListener((observableValue, oldProposal, newProposal) -> {
            if (newProposal != null) {
                acceptBtn.setDisable(false);
            }
        });
        acceptBtn.setOnAction(this.createAcceptHandler());
        this.getContent().addAll((Object[])new Node[]{this.box, acceptBtn});
    }

    private void deactivateAll() {
        for (Node node : this.box.getChildren()) {
            if (!(node instanceof DecoratedText)) continue;
            ((DecoratedText)node).applyStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    private EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            ILoanProposal proposal = (ILoanProposal)this.selectedProposal.get();
            IHumanPlayer debitor = this.city.getPlayer();
            this.loanerService.takeOutLoan((ILoaner)this.loaner, proposal, (IPlayer)debitor, this.city.getCity());
            this.executeOnCloseButtonClicked();
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_LOANER);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

