/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.shipyard;

import ch.sahits.game.event.data.ShipyardOrderRefit;
import ch.sahits.game.graphic.display.dialog.shipyard.BaseShipyardDialog;
import ch.sahits.game.javafx.control.BaleAmountAlwaysVisible;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.BarrelAmountAlwaysVisible;
import ch.sahits.game.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ECellConstraint;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipWeaponsLocation;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shipyardUpgradeDialog")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipyardUpgradeDialogV2
extends BaseShipyardDialog {
    @ObjectPropertyType(value=IShip.class)
    private ObjectProperty<IShip> currentShip;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private ShipWeaponsLocationFactory weaponsLocationFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private static final EWare[] MATERIALS = new EWare[]{EWare.WOOD, EWare.IRON, EWare.PITCH};
    @MapType(key=IWare.class, value=IntegerProperty.class)
    private HashMap<IWare, IntegerProperty> availableMap = new HashMap();
    @MapType(key=IWare.class, value=IntegerBinding.class)
    private HashMap<IWare, IntegerBinding> priceMap = new HashMap();
    @MapType(key=IWare.class, value=BaseShipyardDialog.BuyAmountBinding.class)
    private HashMap<IWare, BaseShipyardDialog.BuyAmountBinding> buyAmountMap = new HashMap();

    public ShipyardUpgradeDialogV2(final ICityPlayerProxyJFX city) {
        super(city);
        this.currentShip = new SimpleObjectProperty((Object)this, "currentShip", null);
        if (city.getActiveShip() instanceof IShip) {
            IShip ship = (IShip)city.getActiveShip();
            this.currentShip.setValue((Object)ship);
        }
        this.enablePreviousNext = new BooleanBinding(){
            {
                super.bind(new Observable[]{city.getPlayersShips()});
            }

            protected boolean computeValue() {
                return city.getPlayersShips().size() > 1;
            }
        };
        if (this.currentShip.get() != null) {
            for (int i = 0; i < this.shipTypes.length; ++i) {
                if (this.shipTypes[i] != ((IShip)this.currentShip.get()).getShipType()) continue;
                this.currentShipTypeIndexProperty().set(i);
                break;
            }
        } else {
            this.currentShipTypeIndexProperty().set(0);
        }
        this.mainTableYPosition = 334;
    }

    @PostConstruct
    private void intializeAdditionalText() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardUpgradeDialogV2.title", new Object[0], this.locale.getCurrentLocal()));
        Text name = new Text();
        name.getStyleClass().add((Object)"dialogText");
        name.setLayoutX(50.0);
        name.setLayoutY(310.0);
        if (this.currentShip.get() != null) {
            name.setText(((IShip)this.currentShip.get()).getName());
            this.currentShip.addListener((observableValue, oldValue, newValue) -> name.setText(newValue.getName()));
            Text level = new Text();
            level.getStyleClass().add((Object)"dialogText");
            level.setLayoutX(50.0);
            level.setLayoutY(334.0);
            level.setText(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardUpgradeDialogV2.upgradeLevel", new Object[]{((IShip)this.currentShip.get()).getShipUpgradeLevel().nextLevel().name()}, this.locale.getCurrentLocal()));
            this.currentShip.addListener((observableValue, oldValue, newValue) -> level.setText(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardUpgradeDialogV2.upgradeLevel", new Object[]{newValue.getShipUpgradeLevel().nextLevel().name()}, this.locale.getCurrentLocal())));
            this.getContent().addAll((Object[])new Node[]{name, level});
        }
    }

    @Override
    protected boolean hasShips() {
        if (this.city.getPlayersShips().size() > 0) {
            return this.city.getPlayersShips().stream().anyMatch(ship -> ship.isAvailable());
        }
        return false;
    }

    @Override
    protected EventHandler<MouseEvent> getAction() {
        return mouseEvent -> {
            ITradingOffice office = this.getPlayer().findTradingOffice(this.getCity());
            for (EWare ware : MATERIALS) {
                int buyAmount = this.buyAmountMap.get(ware).get();
                this.getCity().move((IWare)ware, -buyAmount, (ICitizen)this.getPlayer());
                int needed = this.shipFactory.getUpgradeAmount(((IShip)this.currentShip.get()).getShipType(), ware);
                int fromWarhouse = needed - buyAmount;
                office.move((IWare)ware, -fromWarhouse);
            }
            ShipyardOrderRefit event = new ShipyardOrderRefit(this.getCity().getCityState().getShipyardState(), (IShip)this.currentShip.get(), ((IShip)this.currentShip.get()).getShipUpgradeLevel().nextLevel(), this.city);
            this.clientServerEventBus.post((Object)event);
            this.city.getPlayersShips().remove(this.currentShip.get());
            this.getPlayer().getCompany().updateCash((long)(-this.calculateTotalUpgradeCosts()));
            this.executeOnCloseButtonClicked();
        };
    }

    @Override
    protected String getActionText() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardUpgradeDialogV2.refit", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected Group createFooterText() {
        IntegerBinding totalPriceBinding = new IntegerBinding(){
            {
                for (EWare ware : MATERIALS) {
                    super.bind(new Observable[]{ShipyardUpgradeDialogV2.this.getPriceBinding((IWare)ware, null)});
                }
            }

            protected int computeValue() {
                return ShipyardUpgradeDialogV2.this.calculateTotalUpgradeCosts();
            }
        };
        Group g = new Group();
        String t = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.totalSum", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("price", totalPriceBinding.get());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(t, parameters);
        g.getChildren().add((Object)dt);
        return g;
    }

    private int calculateTotalUpgradeCosts() {
        int total = this.getCity().getCityState().getShipyardState().calculateRefitCosts(((IShip)this.currentShip.get()).getShipType(), 1);
        for (EWare ware : MATERIALS) {
            total += this.getPriceBinding((IWare)ware, null).get();
        }
        return total;
    }

    @Override
    protected Table createMainTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.materials", new Object[0], this.locale.getCurrentLocal())), ECellConstraint.COLSPAN2);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.stored", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.buy", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.costs", new Object[0], this.locale.getCurrentLocal())));
        header.setAligenment(0, HPos.CENTER);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(3, HPos.CENTER);
        header.setAligenment(4, HPos.CENTER);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.RIGHT);
        model.setAligenment(4, HPos.RIGHT);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70, 100});
        for (EWare ware : MATERIALS) {
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            IntegerBinding needed = this.getNeededWareBinding(ware);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.amountProperty().bind((ObservableValue)needed.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.amountProperty().bind((ObservableValue)needed.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            IntegerProperty stored = this.getStoredAmount((IWare)ware);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            BaseShipyardDialog.BuyAmountBinding buyAmount = new BaseShipyardDialog.BuyAmountBinding((IWare)ware, needed);
            this.buyAmountMap.put((IWare)ware, buyAmount);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.amountProperty().bind((ObservableValue)buyAmount.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.amountProperty().bind((ObservableValue)buyAmount.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            IntegerBinding priceBinding = this.getPriceBinding((IWare)ware, buyAmount);
            CoinPriceAlwaysVisible price = new CoinPriceAlwaysVisible();
            price.amountProperty().bind((ObservableValue)priceBinding.asString());
            row.add((ITableCell)new ControlTableCell((Node)price));
            model.add(row);
        }
        return model;
    }

    private IntegerProperty getStoredAmount(IWare ware) {
        if (!this.availableMap.containsKey(ware)) {
            ITradingOffice office = this.getPlayer().findTradingOffice(this.getCity());
            IntegerProperty stored = office.getWare(ware).amountProperty();
            this.availableMap.put(ware, stored);
        }
        return this.availableMap.get(ware);
    }

    private IntegerBinding getPriceBinding(IWare ware, BaseShipyardDialog.BuyAmountBinding buyAmount) {
        if (!this.priceMap.containsKey(ware)) {
            BaseShipyardDialog.PriceBinding priceBinding = new BaseShipyardDialog.PriceBinding(ware, buyAmount);
            this.priceMap.put(ware, priceBinding);
        }
        return this.priceMap.get(ware);
    }

    private IntegerBinding getNeededWareBinding(final EWare ware) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{ShipyardUpgradeDialogV2.this.currentShipTypeIndexProperty()});
            }

            protected int computeValue() {
                return ShipyardUpgradeDialogV2.this.shipFactory.getConstructionAmount(ShipyardUpgradeDialogV2.this.getCurrentShipType(), ware);
            }
        };
    }

    @Override
    protected Table createTopTable() {
        int capacity = this.shipFactory.calculateInitialCapacity(this.getCurrentShipType(), this.getCity().getCoordinates().getX());
        IShipWeaponsLocation shipWeapons = this.weaponsLocationFactory.getShipWeaponsLocation(this.getCurrentShipType(), EShipUpgrade.NONE);
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70, 70});
        TableRow row = new TableRow();
        BarrelAmount capacityAmount = new BarrelAmount();
        capacityAmount.setAmount(Integer.valueOf(capacity));
        row.add((ITableCell)new ControlTableCell((Node)capacityAmount));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(shipWeapons.getNumberOfSmallSlots())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(shipWeapons.getNumberOfLargeSlots())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(this.shipFactory.getShipSpeed(this.getCurrentShipType()))));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(this.shipFactory.getMinimalSailors(this.getCurrentShipType()))));
        model.add(row);
        return model;
    }

    @Override
    protected BooleanBinding actionEnabledBinding() {
        return new BooleanBinding(){
            {
                for (EWare ware : MATERIALS) {
                    IntegerProperty stored = ShipyardUpgradeDialogV2.this.getStoredAmount((IWare)ware);
                    IntegerBinding price = ShipyardUpgradeDialogV2.this.getPriceBinding((IWare)ware, null);
                    IntegerProperty available = ShipyardUpgradeDialogV2.this.getCity().getWare((IWare)ware).amountProperty();
                    super.bind(new Observable[]{stored, price, available});
                }
                super.bind(new Observable[]{ShipyardUpgradeDialogV2.this.getPlayer().getCompany().cashProperty()});
            }

            protected boolean computeValue() {
                long buildCosts;
                long cash = ShipyardUpgradeDialogV2.this.getPlayer().getCompany().getCash();
                if (cash < (buildCosts = (long)ShipyardUpgradeDialogV2.this.calculateTotalUpgradeCosts())) {
                    return false;
                }
                for (EWare ware : MATERIALS) {
                    int storedAmount = ShipyardUpgradeDialogV2.this.getStoredAmount((IWare)ware).get();
                    int available = ShipyardUpgradeDialogV2.this.getCity().getWare((IWare)ware).getAmount();
                    int needed = ShipyardUpgradeDialogV2.this.shipFactory.getUpgradeAmount(((IShip)ShipyardUpgradeDialogV2.this.currentShip.get()).getShipType(), ware);
                    if (needed <= storedAmount + available) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> createNextAction() {
        return mouseEvent -> {
            ObservableList ships = this.city.getPlayersShips();
            if (ships.size() > 1) {
                if (((IShip)ships.get(ships.size() - 1)).equals(this.currentShip)) {
                    this.currentShip.set(ships.get(0));
                } else {
                    for (int i = 0; i < ships.size() - 1; ++i) {
                        if (!((IShip)ships.get(i)).equals(this.currentShip)) continue;
                        this.currentShip.set(ships.get(i + 1));
                        break;
                    }
                }
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> createPreviousAction() {
        return mouseEvent -> {
            ObservableList ships = this.city.getPlayersShips();
            if (ships.size() > 1) {
                if (((IShip)ships.get(0)).equals(this.currentShip)) {
                    this.currentShip.set(ships.get(ships.size() - 1));
                } else {
                    for (int i = 1; i < ships.size(); ++i) {
                        if (!((IShip)ships.get(i)).equals(this.currentShip)) continue;
                        this.currentShip.set(ships.get(i - 1));
                        break;
                    }
                }
            }
        };
    }
}

