/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.ClosableDialog;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.PeopleFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.INonFreeSeaPirate;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernPirateDialog
extends CloseButtonDialog
implements ClosableDialog {
    private final ICityPlayerProxyJFX city;
    @ObjectPropertyType(value=IShip.class)
    private final ObjectProperty<IShip> currentShip;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private SeaPiratesState seaPiratesState;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private PeopleFactory peopleFactory;
    private final IPirate pirate;
    private EventHandler<MouseEvent> hirePirateEventHandler;
    private final TavernState tavernState;

    public TavernPirateDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.currentShip = new SimpleObjectProperty((Object)this, "currentShip", null);
        if (city.getActiveShip() instanceof IShip) {
            this.currentShip.setValue((Object)((IShip)city.getActiveShip()));
        }
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.pirate = city.getCity().getCityState().getTavernState().getPirate();
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateDialog.title", new Object[0], this.locale.getCurrentLocal()));
        int share = (int)Math.rint(this.pirate.getProfitShare() * 100.0);
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateDialog.dialog", new Object[]{this.pirate.getFollowers(), share}, this.locale.getCurrentLocal());
        HashMap parameters = new HashMap();
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().add((Object)dt);
        if (this.currentShip.get() == null) {
            String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.noShip", new Object[0], this.locale.getCurrentLocal());
            DecoratedText noShip = this.decoratedTextFactory.createDecoratedText(template, parameters);
            noShip.setLayoutX(30.0);
            noShip.setLayoutY(300.0);
            this.getContent().add((Object)noShip);
        } else {
            String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateDialog.shipSelection", new Object[0], this.locale.getCurrentLocal());
            DecoratedText selectedShip = this.decoratedTextFactory.createDecoratedText(template, parameters);
            selectedShip.setLayoutX(30.0);
            selectedShip.setLayoutY(300.0);
            this.getContent().add((Object)selectedShip);
            GridPane shipSelectionPane = this.dialogUtil.createShipSelection3LinesForShips(this.city, this.currentShip);
            shipSelectionPane.setLayoutX(30.0);
            shipSelectionPane.setLayoutY(350.0);
            this.getContent().add((Object)shipSelectionPane);
            int xFirstButton = 100;
            int xSecondButton = 294;
            OpenPatricianLargeWaxButton wholeHanse = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateDialog.wholeHanse", new Object[0], this.locale.getCurrentLocal()));
            wholeHanse.getStyleClass().add((Object)"actionButton");
            wholeHanse.setLayoutX((double)xFirstButton);
            wholeHanse.setLayoutY(603.0);
            this.hirePirateEventHandler = event -> {
                boolean wholeHanseFlag = ((Node)event.getSource()).getId().equals("wholeHanse");
                final INonFreeSeaPirate seaPirate = this.peopleFactory.createNewPirate(this.pirate.getName(), (IShip)this.currentShip.get(), (IPlayer)this.city.getPlayer(), wholeHanseFlag ? null : this.city.getCity());
                this.seaPiratesState.add((ISeaPirate)seaPirate);
                int nbDays = this.rnd.nextInt(200) + 30;
                DateTime deadline = this.date.getCurrentDate().plus((long)nbDays);
                TimedTask task = new TimedTask(){

                    public void run() {
                        TavernPirateDialog.this.peopleFactory.free(seaPirate);
                    }
                };
                task.setExecutionTime(deadline);
                this.timedTaskListener.add(task);
                this.city.getPlayer().removeShip((IShip)this.currentShip.get());
                this.city.getPlayer().removeSelectableVessel((INavigableVessel)this.currentShip.get());
                this.pirate.leave();
                int caughtProb = this.rnd.nextInt(3);
                if (caughtProb == 1) {
                    deadline = this.date.getCurrentDate().plus(5L);
                    final int fine = (int)Math.abs((double)(this.city.getPlayer().getCompany().getCash() / 200L) * this.rnd.nextDouble());
                    task = new TimedTask(){

                        public void run() {
                            DisplayMessage msg = new DisplayMessage("ch.sahits.game.event.handler.impl.HirePirateEventHandler.fineMessage", new Object[]{fine});
                            TavernPirateDialog.this.clientEventBus.post((Object)msg);
                            TavernPirateDialog.this.city.getPlayer().getCompany().updateCash((long)(-fine));
                        }
                    };
                    task.setExecutionTime(deadline);
                    this.timedTaskListener.add(task);
                }
                this.executeOnCloseButtonClicked();
            };
            wholeHanse.setOnAction((EventHandler)new WeakEventHandler(this.hirePirateEventHandler));
            wholeHanse.setId("wholeHanse");
            OpenPatricianLargeWaxButton local = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateDialog.local", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            local.getStyleClass().add((Object)"actionButton");
            local.setLayoutX((double)xSecondButton);
            local.setLayoutY(603.0);
            local.setOnAction((EventHandler)new WeakEventHandler(this.hirePirateEventHandler));
            local.setId("local");
            this.getContent().addAll((Object[])new Node[]{wholeHanse, local});
        }
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public void close() {
        super.close();
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, (IPlayer)this.city.getPlayer());
    }
}

