/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.model;

import ch.sahits.game.event.data.ShipBecomesUnavailableEvent;
import ch.sahits.game.event.data.ShipEntersPortEvent;
import ch.sahits.game.event.data.ShipLeavingPort;
import ch.sahits.game.javafx.control.GameStatus;
import ch.sahits.game.javafx.control.MiniMap;
import ch.sahits.game.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.spring.DependentAnnotationConfigApplicationContext;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.ListBinding;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
@UniquePrototype
public class CityPlayerProxyJFX
implements ICityPlayerProxyJFX {
    private ICity city;
    private IHumanPlayer player;
    @ListType(value=INavigableVessel.class)
    private ObservableList<INavigableVessel> playersVessels = FXCollections.observableArrayList();
    @ListType(value=IShip.class)
    @XStreamOmitField
    private ListBinding<IShip> playersShips;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    private INavigableVessel activeShip = null;
    @Autowired
    @XStreamOmitField
    private DependentAnnotationConfigApplicationContext context;

    public CityPlayerProxyJFX(ICity city, IHumanPlayer player, INavigableVessel activeShip) {
        this.city = city;
        this.player = player;
        if (activeShip != null) {
            this.activeShip = activeShip;
            this.playersVessels.add((Object)activeShip);
        }
    }

    @PostConstruct
    private void register() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void activateShip(INavigableVessel ship) {
        this.activeShip = ship;
    }

    public ObservableList<INavigableVessel> getPlayersNavalVessels() {
        return this.playersVessels;
    }

    public void arrive(INavigableVessel ship) {
        if (this.player.getFleet().contains(ship)) {
            this.playersVessels.add((Object)ship);
            if (this.playersVessels.size() == 1) {
                this.activeShip = ship;
            }
        }
        if (ship instanceof IConvoy && ((IConvoy)ship).getPlayers().contains(this.player)) {
            this.playersVessels.add((Object)ship);
        }
    }

    public void leave(INavigableVessel ship) {
        this.playersVessels.remove((Object)ship);
        if (ship.equals(this.activeShip)) {
            this.activeShip = null;
            if (!this.playersVessels.isEmpty()) {
                this.activeShip = (INavigableVessel)this.playersVessels.get(0);
            }
        }
    }

    public ObservableList<IShip> getPlayersShips() {
        if (this.playersShips == null) {
            this.playersShips = new ListBinding<IShip>(){

                protected ObservableList<IShip> computeValue() {
                    ObservableList ships = FXCollections.observableArrayList();
                    for (INavigableVessel vessel : CityPlayerProxyJFX.this.playersVessels) {
                        if (!(vessel instanceof IShip)) continue;
                        ships.add((Object)((IShip)vessel));
                    }
                    return ships;
                }
            };
        }
        return this.playersShips;
    }

    @Subscribe
    public void handleShipLeavesPort(ShipLeavingPort event) {
        if (this.getCity().equals(event.getCity())) {
            this.leave(event.getShip());
        }
    }

    @Subscribe
    public void handleShipEntersPort(ShipEntersPortEvent event) {
        if (this.getCity().equals(event.getCity())) {
            this.arrive(event.getShip());
        }
    }

    @Subscribe
    public void handleShipBecomesUnavailable(ShipBecomesUnavailableEvent event) {
        if (this.city.equals(event.getCity())) {
            this.leave((INavigableVessel)event.getShip());
        }
    }

    public void postLoad() {
        List ships = this.player.findShips(this.city);
        this.playersVessels.clear();
        this.playersVessels.addAll((Collection)ships);
        this.activeShip = !ships.isEmpty() ? (INavigableVessel)this.playersVessels.get(0) : null;
        GameStatus gameStatus = (GameStatus)((Object)this.context.getBean(GameStatus.class));
        gameStatus.bindToPlayer((IPlayer)this.player);
        ViewStatus viewStatus = (ViewStatus)((Object)this.context.getBean(ViewStatus.class));
        viewStatus.setCity(this.city.getName());
        MiniMap miniMap = (MiniMap)((Object)this.context.getBean(MiniMap.class));
        miniMap.initializeMapImage((IPlayer)this.player);
    }

    public ICity getCity() {
        return this.city;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public IHumanPlayer getPlayer() {
        return this.player;
    }

    public INavigableVessel getActiveShip() {
        return this.activeShip;
    }
}

