/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.scene;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.event.data.IGameStateChangeData;
import ch.sahits.game.event.data.NewGame;
import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.event.data.ResumeGame;
import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.scene.MainGameScene;
import ch.sahits.game.graphic.display.util.GameOptionsService;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.javafx.OpenPatricianScene;
import ch.sahits.game.javafx.control.OpenPatricianSlider;
import ch.sahits.game.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.javafx.control.OpenPatricianWoodenTextInput;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.GameFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.sound.ITrackPlayer;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import ch.sahits.game.util.UIFactory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.util.StringUtils;

@UniquePrototype
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class InGameOptionsScene
extends OpenPatricianScene {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private UIFactory uiFactory;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private GameOptionsService gameOptions;
    @Autowired
    private Date date;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private ITrackPlayer soundPlayer;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    private IGame game;
    private SceneChangeable sceneChangeable;
    private OpenPatricianSlider speed;
    private EGameSpeed currentSpeed;
    private OpenPatricianSpinner lodableGames;
    private OpenPatricianSpinner saveableGames;
    private OpenPatricianWoodenTextInput newSaveGame;

    public InGameOptionsScene() {
        super((Region)new StackPane());
        this.getRoot().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(this.getStyleSheetFilename()).toExternalForm());
    }

    public SceneChangeable getSceneChangeable() {
        return this.sceneChangeable;
    }

    public void setSceneChangeable(SceneChangeable sceneChangeable) {
        this.sceneChangeable = sceneChangeable;
    }

    private String getStyleSheetFilename() {
        return "newGame.css";
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @PostConstruct
    private void createControls() {
        this.clientServerEventBus.register((Object)this);
        this.game = this.gameFactory.getGame();
        this.currentSpeed = this.game.getGameSpeed();
        StackPane root = (StackPane)this.getRoot();
        root.setId("IngameOptionsStackPane");
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"grid");
        grid.setAlignment(Pos.CENTER);
        grid.getColumnConstraints().add((Object)new ColumnConstraints(200.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(300.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(300.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
        Label loadLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.load", new Object[0], this.locale.getCurrentLocal()));
        loadLbl.getStyleClass().add((Object)"defaultTextSize24");
        grid.add((Node)loadLbl, 0, 0);
        this.lodableGames = new OpenPatricianSpinner();
        this.lodableGames.setMaxWidth(200.0);
        this.lodableGames.selectedIndexProperty().setValue((Number)0);
        grid.add((Node)this.lodableGames, 1, 0);
        GridPane.setHalignment((Node)this.lodableGames, (HPos)HPos.LEFT);
        this.lodableGames.setMaxWidth(250.0);
        OpenPatricianStoneButton loadBtn = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.load", new Object[0], this.locale.getCurrentLocal()));
        loadBtn.getStyleClass().add((Object)"defaultTextSize24");
        loadBtn.setOnAction(this.createLoadAction());
        grid.add((Node)loadBtn, 3, 0);
        GridPane.setHalignment((Node)loadBtn, (HPos)HPos.LEFT);
        Label saveLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.save", new Object[0], this.locale.getCurrentLocal()));
        saveLbl.getStyleClass().add((Object)"defaultTextSize24");
        grid.add((Node)saveLbl, 0, 1);
        this.saveableGames = new OpenPatricianSpinner();
        this.saveableGames.setMaxWidth(200.0);
        this.saveableGames.selectedIndexProperty().setValue((Number)0);
        grid.add((Node)this.saveableGames, 1, 1);
        GridPane.setHalignment((Node)this.saveableGames, (HPos)HPos.LEFT);
        this.saveableGames.setMaxWidth(250.0);
        this.newSaveGame = new OpenPatricianWoodenTextInput("");
        this.newSaveGame.setSize(25);
        grid.add((Node)this.newSaveGame, 2, 1);
        OpenPatricianStoneButton saveBtn = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.save", new Object[0], this.locale.getCurrentLocal()));
        saveBtn.getStyleClass().add((Object)"defaultTextSize24");
        grid.add((Node)saveBtn, 3, 1);
        GridPane.setHalignment((Node)saveBtn, (HPos)HPos.LEFT);
        Label gameSpeedLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.gameSpeed", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)gameSpeedLbl, 0, 2);
        this.speed = new OpenPatricianSlider(200);
        this.speed.getStyleClass().add((Object)"defaultTextSize24");
        this.speed.setValues(this.gameOptions.getGameSpeedList());
        int index = 0;
        this.currentSpeed = this.game.getGameSpeed();
        for (int i = 0; i < EGameSpeed.values().length; ++i) {
            if (!this.currentSpeed.equals((Object)EGameSpeed.values()[i])) continue;
            index = i;
            break;
        }
        this.speed.selectedIndexProperty().setValue((Number)index);
        grid.add((Node)this.speed, 1, 2);
        GridPane.setHalignment((Node)this.speed, (HPos)HPos.LEFT);
        OpenPatricianStoneButton quit = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.quit", new Object[0], this.locale.getCurrentLocal()));
        quit.getStyleClass().add((Object)"defaultTextSize24");
        quit.setOnAction(mouseEvent -> {
            mouseEvent.consume();
            this.soundPlayer.clearPlayList();
            Platform.exit();
            System.exit(0);
        });
        grid.add((Node)quit, 0, 6);
        GridPane.setHalignment((Node)quit, (HPos)HPos.LEFT);
        OpenPatricianStoneButton back = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.back", new Object[0], this.locale.getCurrentLocal()));
        back.getStyleClass().add((Object)"defaultTextSize24");
        grid.add((Node)back, 3, 6);
        GridPane.setHalignment((Node)back, (HPos)HPos.RIGHT);
        back.setOnAction(this.getBackEvent());
        saveBtn.setOnAction(this.createSaveAction(this.saveableGames, this.newSaveGame, back));
        this.initializeSavedGames();
        root.getChildren().add((Object)grid);
    }

    private void initializeSavedGames() {
        this.lodableGames.setOptions(FXCollections.observableArrayList(this.gameOptions.getSavegames()));
        this.saveableGames.setOptions(FXCollections.observableArrayList(this.gameOptions.getSavegames()));
    }

    public void initializeState() {
        this.timerEventBus.post((Object)new PauseGame());
        this.initializeSavedGames();
    }

    private EventHandler<MouseEvent> getBackEvent() {
        return event -> {
            EGameSpeed currentSpeed;
            EGameSpeed gameSpeed = EGameSpeed.values()[this.speed.getSelectedIndex()];
            if (gameSpeed != (currentSpeed = this.game.getGameSpeed())) {
                this.game.setGameSpeed(gameSpeed);
            }
            MainGameScene mainGame = this.uiFactory.getMainGameScene(this.getRoot().getWidth(), this.getRoot().getHeight());
            this.getSceneChangeable().changeScene(mainGame);
            this.soundPlayer.play();
            this.newSaveGame.setText("");
            this.timerEventBus.post((Object)new ResumeGame());
        };
    }

    private EventHandler<MouseEvent> createSaveAction(OpenPatricianSpinner saveableGames, OpenPatricianWoodenTextInput newSaveGame, OpenPatricianStoneButton back) {
        return event -> {
            String savegameName = newSaveGame.getText();
            if (StringUtils.isEmpty((Object)savegameName)) {
                savegameName = saveableGames.getSelectedValue();
            }
            if (savegameName != null) {
                this.gameOptions.save(savegameName);
            } else {
                this.logger.warn("Game was not saved as no file name was specified.");
            }
            back.getOnAction().handle(event);
        };
    }

    private EventHandler<MouseEvent> createLoadAction() {
        return event -> {
            NewGame newGameDTO = NewGame.builder().difficulty(Difficulty.CHANDLER).firstName("FirstName").lastName("Lastname").hometown("BREMEN").objective(EObjective.ENDLESS).speed(EGameSpeed.SLOW).startYear(1300).male(true).mapName("/standartHanseaticMap.xml").environmentInitialisation(false).build();
            this.date.resetStartYear(0);
            GameStateChange stateChange = new GameStateChange(EGameStatusChange.LOAD_GAME_INIT);
            stateChange.setStateChangeData((IGameStateChangeData)newGameDTO);
            this.clientServerEventBus.post((Object)stateChange);
            while (this.date.getStartYear() == null) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    this.logger.warn("Interrupted while waiting for the startyear to be set.");
                }
            }
        };
    }

    @Subscribe
    public void handleGameStateChange(GameStateChange stateChange) {
        if (stateChange.getStatusChange() == EGameStatusChange.GAME_INITIALISATION_COMPLETE) {
            System.out.println("Load and replace the game");
            this.gameOptions.load(this.lodableGames.getSelectedValue());
        }
        if (stateChange.getStatusChange() == EGameStatusChange.GAME_LOADED) {
            this.uiFactory.invalidate();
            MainGameScene mainGameScene1 = this.uiFactory.getMainGameScene(this.getRoot().getWidth(), this.getRoot().getHeight());
            mainGameScene1.initializeGameView(null);
            Platform.runLater(() -> this.getBackEvent().handle(null));
        }
    }
}

