/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.SpriteAnimation;
import ch.sahits.game.graphic.image.SpriteAnimationFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.GameFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.util.IRebinabable;
import javafx.animation.RotateTransition;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class GameStatus
extends Group
implements IRebinabable {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Text cashTxt;
    private Text dateTxt;
    @Autowired
    private Date gameDate;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    private SpriteAnimationFactory spriteAnimFactory;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private IDataImageLoader imageLoader;
    @Autowired
    private ClientViewState clientViewState;
    private ImageView timeGraphic;
    private ChangeListener<String> dateChangeListener;
    private ChangeListener<String> cashChangeListener;
    private Label time;

    public GameStatus() {
        this.setManaged(false);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".css").toExternalForm());
        this.cashTxt = new Text();
        this.dateTxt = new Text();
    }

    @PostConstruct
    private void initializeControl() {
        Rectangle ph = new Rectangle(250.0, 50.0, (Paint)Color.TRANSPARENT);
        int spacing = 10;
        SimpleStringProperty date = this.createDateProperty();
        this.cashTxt.getStyleClass().addAll((Object[])new String[]{"Text"});
        this.dateTxt.getStyleClass().addAll((Object[])new String[]{"Text"});
        ImageView cashPile = this.spriteAnimFactory.createImageViewForSprite("sprites/coin-pile");
        cashPile.setScaleY(0.5);
        cashPile.setScaleX(0.5);
        this.timeGraphic = new ImageView(this.imageLoader.getImage("icons/64/hourglass"));
        this.time = new Label();
        this.time.setGraphic((Node)this.timeGraphic);
        this.time.setScaleX(0.5);
        this.time.setScaleY(0.5);
        this.time.setOnMouseReleased(event -> {
            IGame game = this.gameFactory.getGame();
            game.fastForward();
        });
        cashPile.setLayoutY(-14.0);
        this.cashTxt.setLayoutX(cashPile.getLayoutX() + 38.0 + 10.0);
        this.cashTxt.setTextOrigin(VPos.BASELINE);
        this.cashTxt.setLayoutY(30.0);
        this.cashChangeListener = (observable, oldValue, newValue) -> {
            SpriteAnimation animation = this.spriteAnimFactory.createAnimation(cashPile, "sprites/coin-pile", true);
            animation.play();
        };
        this.cashTxt.textProperty().addListener(this.cashChangeListener);
        this.time.setLayoutY(-8.0);
        this.time.setLayoutX(ph.getWidth() - 10.0 - 32.0);
        this.dateTxt.setLayoutX(this.time.getLayoutX() - 10.0 - this.dateTxt.getBoundsInLocal().getWidth());
        this.dateTxt.setTextOrigin(VPos.BASELINE);
        this.dateTxt.setLayoutY(30.0);
        this.dateTxt.boundsInLocalProperty().addListener((observableValue, oldBounds, newBounds) -> {
            if (oldBounds.getWidth() != newBounds.getWidth()) {
                this.dateTxt.setLayoutX(this.time.getLayoutX() - 10.0 - newBounds.getWidth());
            }
        });
        this.dateTxt.textProperty().bind((ObservableValue)date);
        this.dateTxt.textProperty().addListener((observable, oldText, newText) -> this.logger.info("Date text changed {}->{}", new Object[]{oldText, newText}));
        this.dateChangeListener = (observableValue, s, t1) -> {
            RotateTransition rotation = new RotateTransition(Duration.millis((double)1200.0), (Node)this.timeGraphic);
            rotation.setByAngle(-360.0);
            rotation.setCycleCount(1);
            rotation.setAutoReverse(false);
            rotation.play();
        };
        this.dateTxt.textProperty().addListener(this.dateChangeListener);
        this.getChildren().addAll((Object[])new Node[]{ph, cashPile, this.cashTxt, this.dateTxt, this.time});
    }

    private SimpleStringProperty createDateProperty() {
        SimpleStringProperty date = new SimpleStringProperty((Object)this, "date", "");
        boolean dateSet = false;
        while (!dateSet) {
            try {
                this.bindDate(date);
                dateSet = true;
            }
            catch (Exception e) {
                this.logger.debug("Failed to bind date, try again");
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    this.logger.warn("Interrupped while waiting for date initialisation");
                }
            }
        }
        if (date.get().equals("") || date.get() == null) {
            this.logger.error("date property not initialized");
        }
        return date;
    }

    private void bindDate(SimpleStringProperty date) {
        date.bind((ObservableValue)this.gameDate.dayDateBinding());
        this.gameDate.dayDateBinding().addListener((observable, oldValue, newValue) -> {
            date.unbind();
            date.bind((ObservableValue)this.gameDate.dayDateBinding());
        });
    }

    public void bindToPlayer(IPlayer player) {
        this.cashTxt.textProperty().bind((ObservableValue)player.getCompany().cashProperty().asString());
    }

    public void setFont(Font f) {
        this.cashTxt.setFont(f);
        this.dateTxt.setFont(f);
    }

    public void rebind() {
        this.cashTxt.textProperty().removeListener(this.cashChangeListener);
        this.cashTxt.textProperty().unbind();
        this.cashTxt.textProperty().addListener(this.cashChangeListener);
        this.gameDate.invalidate();
        this.dateTxt.textProperty().removeListener(this.dateChangeListener);
        this.dateTxt.textProperty().unbind();
        SimpleStringProperty date = this.createDateProperty();
        this.dateTxt.textProperty().bind((ObservableValue)date);
        this.dateTxt.textProperty().addListener(this.dateChangeListener);
    }
}

