/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NavigationStateChange;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.event.data.MapUpdateCityAdd;
import ch.sahits.game.event.data.NewGameClient;
import ch.sahits.game.event.data.ShipEntersPortEvent;
import ch.sahits.game.event.data.ShipLeavingPort;
import ch.sahits.game.event.data.SwitchCity;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.EViewState;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.ui.MapState;
import ch.sahits.game.openpatrician.util.IRebinabable;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.JAVAFX, EClassCategory.SINGLETON_BEAN})
public class MiniMap
extends Group
implements IRebinabable {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private IMap map;
    @Autowired
    private IImageUtilities imageUtilities;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private MapState mapState;
    private ImageView imgView;
    private boolean navigationDisabled = false;
    private IDialogContoller dialogContoller;
    private Pane mapPane;
    private double scale;

    @PostConstruct
    private void initializeControl() {
        this.clientServerEventBus.register((Object)this);
        this.clientEventBus.register((Object)this);
        this.setManaged(false);
        this.mapPane = new Pane();
        this.imgView = new ImageView();
        this.imgView.setFitWidth(236.0);
        this.imgView.setFitHeight(192.0);
        this.imgView.setPreserveRatio(false);
        this.mapPane.getChildren().addAll((Object[])new Node[]{this.imgView});
        this.getChildren().add((Object)this.mapPane);
        this.addEventHandlers();
    }

    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    private void addEventHandlers() {
        this.setOnMouseReleased(event -> {
            if (this.viewState.getState() == EViewState.MAP) {
                System.out.println("Switch back to port scene");
                this.mapState.setShowingLargeSeaMap(false);
                ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_PORT);
                this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
            } else if (this.mapState.isMiniMapShowingSea()) {
                System.out.println("Switch to big sea map");
                this.mapState.setShowingLargeSeaMap(true);
                this.dialogContoller.closeDialog();
                ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_SEA_MAP);
                this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_HIDE);
                this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
            } else {
                System.out.println("Cannot switch from town view to sea map");
            }
        });
    }

    @PreDestroy
    private void destroy() {
        this.clientServerEventBus.unregister((Object)this);
        this.clientEventBus.unregister((Object)this);
    }

    @Subscribe
    public void initializeState(NewGameClient newGameDTO) {
        IHumanPlayer player = newGameDTO.getPlayer();
        this.initializeMapImage((IPlayer)player);
    }

    public void initializeMapImage(IPlayer player) {
        Image mapImage = this.imageUtilities.createMapWithCities(this.map, player);
        Dimension2D dim = this.map.getDimension();
        this.scale = 192.0 / dim.getHeight();
        double widthOrigImg = 236.0 / this.scale;
        double xlocation = player.getHometown().getCoordinates().getX();
        double x = Math.max(0.0, xlocation - widthOrigImg / 2.0);
        Rectangle2D viewport = new Rectangle2D(x, 0.0, widthOrigImg, dim.getHeight());
        Image transferableMap = mapImage;
        Platform.runLater(() -> {
            this.imgView.setViewport(viewport);
            this.imgView.setImage(transferableMap);
            for (ICity city : this.map.getCities()) {
                List ships;
                if (!(city.getCoordinates().getX() >= x) || !(city.getCoordinates().getX() <= x + widthOrigImg) || (ships = player.findShips(city)).isEmpty()) continue;
                this.drawShipPresenceInCity(city, x);
            }
        });
    }

    private void drawShipPresenceInCity(ICity city, double offset) {
        int radius = 8;
        int cityX = (int)Math.rint(city.getCoordinates().getX());
        int cityY = (int)Math.rint(city.getCoordinates().getY());
        Circle c = new Circle(((double)cityX - offset) * this.scale, (double)cityY * this.scale, (double)radius * this.scale, (Paint)Color.WHITE);
        this.mapPane.getChildren().add((Object)c);
    }

    @Subscribe
    public void handleMapChange(MapUpdateCityAdd event) {
        this.initializeMapImage(event.getPlayer());
    }

    @Subscribe
    public void handleShipLeavesCity(ShipLeavingPort event) {
        List ships;
        ICity city = event.getCity();
        IShipOwner owner = event.getShip().getOwner();
        if (owner instanceof IHumanPlayer && owner.equals(this.viewState.getPlayer()) && (ships = ((IHumanPlayer)owner).findShips(city)).isEmpty()) {
            double cityX = (double)((int)Math.rint(city.getCoordinates().getX())) * this.scale;
            double cityY = (double)((int)Math.rint(city.getCoordinates().getY())) * this.scale;
            double viewportOffset = this.imgView.getViewport().getMinX() * this.scale;
            Iterator iterator = this.mapPane.getChildren().iterator();
            while (iterator.hasNext()) {
                Circle c;
                Node node = (Node)iterator.next();
                if (!(node instanceof Circle) || (c = (Circle)node).getCenterX() + viewportOffset != cityX || c.getCenterY() != cityY) continue;
                Platform.runLater(() -> iterator.remove());
                break;
            }
        }
    }

    @Subscribe
    public void handleShipEntersPort(ShipEntersPortEvent event) {
        List ships;
        ICity city = event.getCity();
        IShipOwner owner = event.getShip().getOwner();
        if (owner instanceof IHumanPlayer && owner.equals(this.viewState.getPlayer()) && (ships = ((IHumanPlayer)owner).findShips(city)).size() == 1) {
            Dimension2D dim = this.map.getDimension();
            this.scale = 192.0 / dim.getHeight();
            double viewportOffset = this.imgView.getViewport().getMinX();
            Platform.runLater(() -> this.drawShipPresenceInCity(city, viewportOffset));
            if (this.shouldSwitchToCity(city)) {
                this.clientEventBus.post((Object)new SwitchCity(city));
            }
        }
    }

    private boolean shouldSwitchToCity(ICity toCity) {
        if (this.viewState.getCurrentCityProxy().isPresent()) {
            IHumanPlayer player;
            ICity currentCity = this.viewState.getCurrentCityProxy().get().getCity();
            if (!currentCity.findBuilding(ITradingOffice.class, Optional.of(player = this.viewState.getPlayer())).isEmpty()) {
                return false;
            }
            return !player.findShips(currentCity).isEmpty();
        }
        return true;
    }

    @Subscribe
    public void handleNavigationChange(NavigationStateChange event) {
        switch (event.getChange()) {
            case DISABLE_NAVIGATION: {
                this.navigationDisabled = true;
                break;
            }
            case ENABLE_NAVIGATION: {
                this.navigationDisabled = false;
                break;
            }
            default: {
                this.logger.info("Not interested in navigation change event: " + event.getChange());
            }
        }
    }

    public void rebind() {
        Iterator iterator = this.mapPane.getChildren().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof Circle)) continue;
            iterator.remove();
        }
    }
}

