package ch.sahits.game.graphic.display.dialog.action;


import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.IWare;
import javafx.beans.property.SimpleIntegerProperty;
/**
 * This action handles the buying of wares from the city and storing them in the storage
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
@ClassCategory(EClassCategory.HANDLER)
class City2StorageJFXAction implements Runnable {
	private final IWare ware;
	private final ITransferableJFX transfer;
//	private static final Logger logger = Logger.getLogger(City2StorageAction.class);

	public City2StorageJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer=transfer;
	}

	@Override
	public void run() {
		ComputablePriceV2 computablePrice = new ComputablePriceV2();
		int availableAmountCity = transfer.getCity().getWare(ware).getAmount();
		ITradingOffice office = transfer.getPlayer().findTradingOffice(transfer.getCity());
		if (availableAmountCity>0 && office!=null){
			int amount2Move = transfer.getAmount(availableAmountCity); // This is ware specific size
			int avgPrice = computablePrice.buyPrice(ware, new SimpleIntegerProperty(availableAmountCity), new ConstantIntegerBinding(amount2Move));
			// check if this is afforable
			final long cash = transfer.getPlayer().getCompany().getCash();
			if (cash<(long)avgPrice*amount2Move){
				int amountAprox = (int) (cash/avgPrice); // approx amount we can afford
				if (amountAprox>0){
					int tempPrice = computablePrice.buyPrice(ware, new SimpleIntegerProperty(availableAmountCity), new ConstantIntegerBinding(amountAprox));
					while (amountAprox*tempPrice+tempPrice<cash){
						int newTempPrice = computablePrice.buyPrice(ware, new SimpleIntegerProperty(availableAmountCity), new ConstantIntegerBinding(++amountAprox));
						if (amountAprox*newTempPrice>cash){
							// we cannot afford another item
							break;
						}
						tempPrice=newTempPrice;
					}
					avgPrice=tempPrice;
					amount2Move=amountAprox;
				} else {
					return; // cannot buy anything
				}
			}
			int movedAmount = transfer.getCity().move(ware, -amount2Move,transfer.getPlayer());
			if (amount2Move!=-movedAmount){
				avgPrice = computablePrice.buyPrice(ware, new SimpleIntegerProperty(transfer.getCity().getWare(ware).getAmount()+movedAmount),
		                 new ConstantIntegerBinding(movedAmount));
				amount2Move=movedAmount;
			}
			int loaded = office.move(ware, amount2Move,avgPrice);
			transfer.getPlayer().getCompany().updateCash(-avgPrice*loaded);
		}
	}
}
