package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.beans.property.SimpleIntegerProperty;

import java.util.Map;
import java.util.Map.Entry;

/**
 * Action of selling stuff to the city from the ship
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 23, 2011
 *
 */
@ClassCategory(EClassCategory.HANDLER)
class Ship2CityJFXAction implements Runnable{
	private final IWare ware;
	private final ITransferableJFX transfer;

	public Ship2CityJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer=transfer;
	}

	@Override
	public void run() {
		final INavigableVessel vessel = transfer.getVessel();
		int amountOnShip = vessel.getWare(ware).getAmount();
		if (amountOnShip>0){
			final ICity city = transfer.getCity();
			int availableAmountCity = city.getWare(ware).getAmount();
			int amount2Move = transfer.getAmount(amountOnShip);
			final int avgPrice;
			if (transfer.getMovableAmount()==ETransferAmount.MAX){
				avgPrice = ware.getMaxValueSell();
			} else {
				avgPrice = transfer.getComputablePrice().sellPrice(ware, new SimpleIntegerProperty(availableAmountCity), new ConstantIntegerBinding(amount2Move));
			}
			final IPlayer player = transfer.getPlayer();
			city.move(ware, amount2Move, player); // The price here is irrelevant
			int sold = vessel.unload(ware, -amount2Move);
			if (vessel instanceof IShip) {
				player.getCompany().updateCash(avgPrice * sold);
			} else {
				IConvoy convoy = (IConvoy) vessel;
				Map<IPlayer, Integer> capacityMap = convoy.getCapacityPerOwner();
				long totalCash = avgPrice * sold;
				double totalCapacity = convoy.getCapacity();
				for (Entry<IPlayer, Integer> entry : capacityMap.entrySet()) {
					double percentage = entry.getValue()/totalCapacity;
					long partialAmount = Math.round(totalCash*percentage);
					entry.getKey().getCompany().updateCash(partialAmount);
				}
			}
		}
	}
}
