/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.data.PatrolInternalState;
import ch.sahits.game.event.data.ShipEntersPortEvent;
import ch.sahits.game.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.event.handler.impl.AttackListener;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class NextPatrolStation
extends ShipEntersPortEventListener {
    private final PatrolInternalState state;
    private final IPlayer player;
    private final DateTime deadline;
    private final AttackListener atackListener;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private ClientTaskFactory taskFactory;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private MessageSource messageSource;

    public NextPatrolStation(IShip ship, ICity city, PatrolInternalState state, IPlayer player, DateTime deadline, AttackListener atackListener) {
        super((INavigableVessel)ship, city);
        this.state = state;
        this.player = player;
        this.deadline = deadline;
        this.atackListener = atackListener;
        state.removeFirstCity();
    }

    @PostConstruct
    private void initEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void handleShipEntersPort(ShipEntersPortEvent event) {
        super.handleShipEntersPort(event);
        DateTime now = this.date.getCurrentDate();
        if (now.isAfter((ReadableInstant)this.deadline)) {
            this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.event.handler.impl.NextCourierPatrolStation.unreliable", new Object[0]));
            this.clientServerEventBus.unregister((Object)this);
            this.clientServerEventBus.unregister((Object)this.atackListener);
        }
    }

    public boolean execute() {
        Optional<ICity> nextCity = this.state.nextDestination();
        if (!nextCity.isPresent()) {
            int premium = this.state.getPremium() + this.state.getNumberOfAttacks() * this.state.getBonusPerAttack();
            this.player.getCompany().updateCash((long)premium);
            this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.event.handler.impl.NextPatrolStation.premium", new Object[]{premium}));
            this.clientServerEventBus.unregister((Object)this.atackListener);
            this.unregisterEventBus();
            this.clientServerEventBus.unregister((Object)this.atackListener);
        } else {
            ICity next = nextCity.get();
            this.state.removeFirstCity();
            int minutes = this.rnd.nextInt(600);
            DateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
            this.taskFactory.getPostponedDisplayMessage(postMessage, "ch.sahits.game.event.handler.impl.NextCourierPatrolStation.nextStation", next.getName());
            DateTime deadline = this.date.getCurrentDate().plusDays(6);
            new NextPatrolStation((IShip)this.getShip(), this.state.nextDestination().get(), this.state, this.player, deadline, this.atackListener);
        }
        return true;
    }
}

