/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.personal.IMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@UniquePrototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class PersonalDialog
extends CloseButtonDialog {
    protected final ICityPlayerProxyJFX city;
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    private DecoratedTextFactory textFactory;

    public PersonalDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.personal", new Object[0], this.locale.getCurrentLocal()));
        IHumanPlayer player = this.city.getPlayer();
        IPersonalData personalData = player.getPersonalData();
        IReputation rep = this.city.getCity().getReputation((IPlayer)player);
        VBox box = new VBox();
        box.setLayoutX(30.0);
        box.setLayoutY(80.0);
        this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.name", new Object[]{personalData.getName(), personalData.getLastName(), this.modelTranslator.getLocalDisplayName(player.getCareerLevel()), this.modelTranslator.getLocalDisplayName(player.getRank())}, this.locale.getCurrentLocal()));
        box.getChildren().add((Object)this.createEmptyNode());
        ICity birthPlace = personalData.getBirthPlace();
        DateTime birthDate = personalData.getBirthDate();
        this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.birthInfo", new Object[]{this.modelTranslator.toDisplayString(birthDate), birthPlace.getName(), personalData.getAge(this.date.getCurrentDate())}, this.locale.getCurrentLocal()));
        box.getChildren().add((Object)this.createEmptyNode());
        this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.hometown", new Object[]{player.getHometown().getName()}, this.locale.getCurrentLocal()));
        box.getChildren().add((Object)this.createEmptyNode());
        this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.socialStatus", new Object[]{this.modelTranslator.getLocalDisplayName(this.city.getPlayer().getRank())}, this.locale.getCurrentLocal()));
        this.createAndAddNewText(box, this.getReputationText(rep));
        List<String> careerAdvice = this.getCareerAdvice((IPlayer)player, rep);
        if (careerAdvice.isEmpty()) {
            box.getChildren().add((Object)this.createEmptyNode());
            box.getChildren().add((Object)this.createEmptyNode());
        } else {
            this.createAndAddNewText(box, careerAdvice.get(0));
            this.createAndAddNewText(box, careerAdvice.get(1));
        }
        this.createAndAddNewText(box, this.getUnderworldReputation((IPlayer)player));
        box.getChildren().add((Object)this.createEmptyNode());
        ISpouseData spouseData = player.getSpouseData();
        if (spouseData != null) {
            this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.married", new Object[]{this.getPrefix(spouseData), spouseData.getName(), spouseData.getLastName()}, this.locale.getCurrentLocal()));
            birthDate = spouseData.getBirthDate();
            this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.birthInfo", new Object[]{this.modelTranslator.toDisplayString(birthDate), spouseData.getBirthPlace().getName(), spouseData.getAge(this.date.getCurrentDate())}, this.locale.getCurrentLocal()));
            box.getChildren().add((Object)this.createEmptyNode());
            this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.children", new Object[]{spouseData.getNumberOfChildren()}, this.locale.getCurrentLocal()));
            box.getChildren().add((Object)this.createEmptyNode());
            List<String> spouseReputation = this.getSpouseReputation((IPlayer)player, spouseData);
            this.createAndAddNewText(box, spouseReputation.get(0));
            this.createAndAddNewText(box, spouseReputation.get(1));
        }
        this.getContent().add((Object)box);
    }

    private void createAndAddNewText(VBox box, String s) {
        DecoratedText text = this.textFactory.createDecoratedText(s, new HashMap());
        box.getChildren().add((Object)text);
    }

    private Node createEmptyNode() {
        DecoratedText text = this.textFactory.createDecoratedText("", new HashMap());
        return text;
    }

    private String getReputationText(IReputation reputation) {
        int repDiff = reputation.getReputationDifference();
        StringBuilder sb = new StringBuilder();
        if (repDiff < 0) {
            if (repDiff <= -10 && repDiff > -25) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.sunkenRep1", new Object[0], this.locale.getCurrentLocal()));
            } else if (repDiff > -10) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.sunkenRep2", new Object[0], this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.sunkenRep3", new Object[0], this.locale.getCurrentLocal()));
            }
        } else if (repDiff > 0) {
            if (repDiff >= 10 && repDiff < 25) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.risenRep1", new Object[0], this.locale.getCurrentLocal()));
            } else if (repDiff < 10) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.risenRep2", new Object[0], this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.risenRep3", new Object[0], this.locale.getCurrentLocal()));
            }
        } else {
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.unchangedRep", new Object[0], this.locale.getCurrentLocal()));
        }
        return sb.toString();
    }

    private List<String> getCareerAdvice(IPlayer player, IReputation reputation) {
        ESocialRank rank = player.getRank();
        ArrayList<String> lines = new ArrayList<String>();
        if (rank != ESocialRank.ALDERMAN && rank != ESocialRank.MAYOR) {
            ESocialRank nextRank = rank.getNextRank();
            boolean needFortune = false;
            if (player.getCompany().getCompanyValue() < (long)nextRank.getCompanyValue()) {
                needFortune = true;
            }
            boolean needReputation = false;
            if (reputation.getPopularity() < nextRank.getSocialReputation()) {
                needReputation = true;
            }
            StringBuilder sb = new StringBuilder();
            if (needFortune && needReputation) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
                lines.add(sb.toString());
                sb = new StringBuilder();
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_2", new Object[0], this.locale.getCurrentLocal()));
                lines.add(sb.toString());
            } else if (needFortune) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice2_1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
                lines.add(sb.toString());
                sb = new StringBuilder();
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_2", new Object[0], this.locale.getCurrentLocal()));
                lines.add(sb.toString());
            } else if (needReputation) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice3_1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
                lines.add(sb.toString());
                sb = new StringBuilder();
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_2", new Object[0], this.locale.getCurrentLocal()));
                lines.add(sb.toString());
            }
        }
        return lines;
    }

    public List<String> getSpouseReputation(IPlayer player, ISpouseData spouse) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (this.city.getCity() == spouse.getBirthPlace()) {
            if (spouse.isMale()) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep2", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            }
            lines.add(sb.toString());
            sb = new StringBuilder();
            lines.add(sb.toString());
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep3", new Object[0], this.locale.getCurrentLocal()));
        } else if (this.city.getCity() == player.getCompany().getHomeTown()) {
            if (spouse.isMale()) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep2", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            }
            lines.add(sb.toString());
            sb = new StringBuilder();
            lines.add(sb.toString());
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep3", new Object[0], this.locale.getCurrentLocal()));
        } else {
            if (spouse.isMale()) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep2", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            }
            lines.add(sb.toString());
            sb = new StringBuilder();
            lines.add(sb.toString());
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep3", new Object[0], this.locale.getCurrentLocal()));
        }
        return lines;
    }

    private String getUnderworldReputation(IPlayer player) {
        ICareer careerLevel = player.getCareerLevel();
        String s = careerLevel instanceof IMilitantCareer ? ((EMilitantCareer)careerLevel != EMilitantCareer.BOISTEROUS && (EMilitantCareer)careerLevel != EMilitantCareer.BOLD ? this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.underworldRep1", new Object[0], this.locale.getCurrentLocal()) : this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.underworldRep2", new Object[0], this.locale.getCurrentLocal())) : this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.underworldRep2", new Object[0], this.locale.getCurrentLocal());
        return s;
    }

    private String getPrefix(ISpouseData spouseData) {
        if (spouseData.isMale()) {
            return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.malePrefix", new Object[0], this.locale.getCurrentLocal());
        }
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.femalePrefix", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

