/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.BaseTradeDialog;
import ch.sahits.game.javafx.control.BarrelIconView;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class StorageShipTradeDialog
extends BaseTradeDialog {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public StorageShipTradeDialog(ICityPlayerProxyJFX city) {
        super(city, EDialogType.PORT_STORAGE_TO_SHIP);
    }

    @Override
    protected String getTradeToDestination() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ship", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected String getTradeFromDestination() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected String getSecondMoveActionHeaderTextKey() {
        return "ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.toShip";
    }

    @Override
    protected String getFirstMoveActionHeaderTextKey() {
        return "ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.toStorage";
    }

    @Override
    protected Group createSubTitle(ICityPlayerProxyJFX city) {
        final INavigableVessel ship = city.getActiveShip();
        String shipNameLabel = ship.getName();
        if (ship instanceof IConvoy) {
            shipNameLabel = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.convoyName", new Object[]{shipNameLabel}, this.locale.getCurrentLocal());
        }
        final String shipName = shipNameLabel;
        StringBinding shipLoad = new StringBinding(){
            {
                super.bind(new Observable[]{ship.getLoadBinding()});
            }

            protected String computeValue() {
                return ship.getLoadBinding().asString().get() + " / " + ship.getLoadableSpace() + " " + shipName;
            }
        };
        Text cityText = new Text();
        cityText.setWrappingWidth(160.0);
        cityText.textProperty().bind((ObservableValue)shipLoad);
        cityText.getStyleClass().add((Object)"dialogText");
        Group g = new Group();
        g.setManaged(false);
        final ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity());
        BarrelIconView barrel = new BarrelIconView();
        barrel.setLayoutX(174.0);
        barrel.setLayoutY(-12.0);
        StringBinding storageLoad = new StringBinding(){
            {
                super.bind(new Observable[]{office.storedAmountBinding(), office.capacityProperty()});
            }

            protected String computeValue() {
                return office.storedAmountBinding().asString().get() + " / " + office.capacityProperty().get();
            }
        };
        Text shipSpace = new Text();
        shipSpace.textProperty().bind((ObservableValue)storageLoad);
        shipSpace.getStyleClass().add((Object)"dialogText");
        shipSpace.setLayoutX(200.0);
        Text storage = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal()));
        storage.getStyleClass().add((Object)"dialogText");
        storage.setLayoutX(300.0);
        g.getChildren().addAll((Object[])new Node[]{cityText, barrel, shipSpace, storage});
        return g;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

