/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

@ClassCategory(value={EClassCategory.HANDLER})
class Storage2CityJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;

    public Storage2CityJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        int amountInStorage;
        ITradingOffice office = this.transfer.getPlayer().findTradingOffice(this.transfer.getCity());
        if (office != null && (amountInStorage = office.getWare(this.ware).getAmount()) > 0) {
            int avgPrice;
            int availableAmountCity = this.transfer.getCity().getWare(this.ware).getAmount();
            int amount2Move = this.transfer.getAmount(amountInStorage);
            if (this.transfer.getMovableAmount() == ETransferAmount.MAX) {
                avgPrice = this.ware.getMaxValueSell();
            } else {
                ComputablePriceV2 computablePrice = new ComputablePriceV2();
                avgPrice = computablePrice.sellPrice((ITradable)this.ware, (IntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amount2Move));
            }
            this.transfer.getCity().move(this.ware, amount2Move, (ICitizen)this.transfer.getPlayer());
            int sold = office.move(this.ware, -amount2Move);
            this.transfer.getPlayer().getCompany().updateCash((long)(avgPrice * sold));
        }
    }
}

