/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import java.util.Map;

@ClassCategory(value={EClassCategory.HANDLER})
public class Storage2ShipJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;

    public Storage2ShipJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        INavigableVessel ship = this.transfer.getVessel();
        IPlayer player = this.transfer.getPlayer();
        ITradingOffice office = player.findTradingOffice(this.transfer.getCity());
        if (office != null && office.getWare(this.ware).getAmount() > 0) {
            AmountablePrice amountable = office.getWare(this.ware);
            int availableAmountStorage = amountable.getAmount();
            int amount2Move = this.transfer.getAmount(availableAmountStorage);
            int avgPrice = amountable.getAVGPrice();
            int moved = office.move(this.ware, -amount2Move, avgPrice);
            ship.load(this.ware, moved, avgPrice);
            if (ship instanceof IConvoy) {
                IConvoy convoy = (IConvoy)ship;
                Map capacityMap = convoy.getCapacityPerOwner();
                long totalCash = -avgPrice * moved;
                double totalCapacity = convoy.getCapacity();
                for (Map.Entry entry : capacityMap.entrySet()) {
                    if (((IPlayer)entry.getKey()).equals(player)) continue;
                    double percentage = (double)((Integer)entry.getValue()).intValue() / totalCapacity;
                    long partialAmount = Math.round((double)totalCash * percentage);
                    ((IPlayer)entry.getKey()).getCompany().updateCash(partialAmount);
                    player.getCompany().updateCash(-partialAmount);
                }
            }
        }
    }
}

