/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.cityhall;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.event.data.ElectionWinnerNotification;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.land.city.CityHallEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.EElectionType;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class HanseaticInfoDialog
extends CloseButtonDialog {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private CityHallEngine cityHallEngine;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    private Date date;
    @Autowired
    private DateService dateService;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    private final ICityPlayerProxyJFX city;
    private VBox box;
    private boolean displayAtElectionDay = false;
    private StyleableObjectProperty<Font> font;

    public HanseaticInfoDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.HanseaticInfoDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.resetContent();
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
    }

    private void resetContent() {
        DecoratedText text;
        String template;
        this.getContent().remove((Object)this.box);
        ICity town = this.city.getCity();
        ICityHall cityHall = this.cityHallEngine.findCityHall(town);
        DateTime electionDate = cityHall.getAldermanElectionDate();
        DateTime today = this.date.getCurrentDate();
        this.box = this.textFactory.createMultiParagraphContainer();
        ICitizen alderman = cityHall.getAlderman();
        boolean articleMale = true;
        if (alderman instanceof IHumanPlayer && !((IPlayer)alderman).isMale()) {
            articleMale = false;
        }
        String attribute = this.modelTranslator.getLocalDisplayName((ICareer)EEconomicCareer.HONEST);
        if (alderman instanceof IHumanPlayer) {
            attribute = this.modelTranslator.getLocalDisplayName(((IPlayer)alderman).getCareerLevel());
        }
        Object[] args = new Object[]{this.modelTranslator.getLocalDisplayDistinctArticle(articleMale, false), attribute, alderman.getName() + " " + alderman.getLastName(), alderman.getHometown().getName()};
        if (this.dateService.isSameDay(electionDate, today)) {
            template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.HanseaticInfoDialog.electionDay", new Object[]{this.modelTranslator.toDisplayString(electionDate), alderman.getHometown().getName()}, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            this.box.getChildren().add((Object)text);
            this.displayAtElectionDay = true;
        } else {
            template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.HanseaticInfoDialog.paragraph1", args, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            this.box.getChildren().add((Object)text);
            template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.HanseaticInfoDialog.paragraph2", new Object[]{this.modelTranslator.toDisplayString(electionDate), alderman.getHometown().getName()}, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            this.box.getChildren().add((Object)text);
            this.displayAtElectionDay = false;
        }
        List candidates = cityHall.getAldermanCandidates().getAll();
        for (ICitizen candidate : candidates) {
            text = this.getCandidateRow(candidate);
            this.box.getChildren().add((Object)text);
        }
        this.getContent().addAll((Object[])new Node[]{this.box});
    }

    private DecoratedText getCandidateRow(ICitizen candidate) {
        Object[] args;
        if (candidate instanceof IPlayer) {
            IPlayer p = (IPlayer)candidate;
            args = new Object[]{this.modelTranslator.getLocalDisplayDistinctArticle(p.isMale(), true), this.modelTranslator.getLocalDisplayName(p.getCareerLevel()), this.modelTranslator.getLocalDisplayName(p.getRank()), p.getName() + " " + p.getLastName()};
        } else {
            args = new Object[]{this.modelTranslator.getLocalDisplayDistinctArticle(true, true), this.modelTranslator.getLocalDisplayName((ICareer)EEconomicCareer.SMART), this.modelTranslator.getLocalDisplayName(candidate.getRank()), candidate.getName() + " " + candidate.getLastName()};
        }
        String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TownInfoNotice.candidate", args, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        return text;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_ALDERMAN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void checkDayChangeUpdates(ClockTickDayChange dayChange) {
        ICity town = this.city.getCity();
        ICityHall cityHall = this.cityHallEngine.findCityHall(town);
        DateTime electionDate = cityHall.getAldermanElectionDate();
        if (this.dateService.isSameDay(electionDate, this.date.getCurrentDate())) {
            Platform.runLater(() -> this.resetContent());
        }
    }

    @Subscribe
    public void checkPostDayChangeUpdates(ElectionWinnerNotification electionResult) {
        ICity town;
        ICityHall cityHall;
        DateTime electionDate;
        if (this.displayAtElectionDay && electionResult.getElectionType().equals((Object)EElectionType.ALDERMAN) && electionResult.getCity().equals(this.city.getCity()) && !this.dateService.isSameDay(electionDate = (cityHall = this.cityHallEngine.findCityHall(town = this.city.getCity())).getAldermanElectionDate(), this.date.getCurrentDate())) {
            Platform.runLater(() -> this.resetContent());
        }
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return HanseaticInfoDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<HanseaticInfoDialog, Font> FONT = new CssMetaData<HanseaticInfoDialog, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(HanseaticInfoDialog control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(HanseaticInfoDialog control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

