/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.cityhall;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.util.JavaFXUtils;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.land.city.CityHallEngine;
import ch.sahits.game.openpatrician.engine.land.city.OutriggerService;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.IOutriggerContract;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.OutriggerContract;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class OutriggerNoticeDialog
extends CloseButtonDialog {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private CityHallEngine cityHallEngine;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private OutriggerService outriggerService;
    @Autowired
    private ShipService shipService;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private XMLImageLoader imageLoader;
    @Autowired
    private JavaFXUtils fxUtils;
    @ListType(value=IShip.class)
    private ObservableList<IShip> capableShips;
    private ListChangeListener<IShip> availableShipChangeListener;
    private final IntegerProperty currentIndex = new SimpleIntegerProperty(0);
    private BooleanBinding capableShipPresent;
    private BooleanBinding enablePreviousNext;
    private final ICityPlayerProxyJFX city;
    private StyleableObjectProperty<Font> font;

    public OutriggerNoticeDialog(final ICityPlayerProxyJFX city) {
        this.city = city;
        this.getStylesheets().add((Object)this.getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
        this.capableShipPresent = new BooleanBinding(){
            {
                super.bind(new Observable[]{city.getPlayersShips()});
            }

            protected boolean computeValue() {
                return !OutriggerNoticeDialog.this.getCapableShips().isEmpty();
            }
        };
        this.enablePreviousNext = new BooleanBinding(){
            {
                super.bind(new Observable[]{city.getPlayersShips()});
            }

            protected boolean computeValue() {
                return OutriggerNoticeDialog.this.getCapableShips().size() > 1;
            }
        };
        this.capableShips = FXCollections.observableArrayList();
        this.availableShipChangeListener = c -> this.capableShips.setAll(this.getCapableShips());
        city.getPlayersShips().addListener((ListChangeListener)new WeakListChangeListener(this.availableShipChangeListener));
        this.capableShips.addListener((ListChangeListener)new ListChangeListener<IShip>(){

            public void onChanged(ListChangeListener.Change<? extends IShip> c) {
                if (OutriggerNoticeDialog.this.capableShips.size() <= OutriggerNoticeDialog.this.currentIndex.get()) {
                    OutriggerNoticeDialog.this.currentIndex.setValue((Number)(OutriggerNoticeDialog.this.capableShips.size() - 1));
                }
            }
        });
    }

    private List<IShip> getCapableShips() {
        int minWeaponStrength = this.outriggerService.getRequiredWeaponStrength(this.city.getCity());
        ArrayList<IShip> ships = new ArrayList<IShip>();
        for (IShip ship : this.city.getPlayersShips()) {
            if (!ship.getCaptian().isPresent() || ship.getNumberOfSailors() < 20 || ship.getDamage() >= 50 || this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship) < minWeaponStrength) continue;
            ships.add(ship);
        }
        return ships;
    }

    @PostConstruct
    private void initializeDialog() {
        this.capableShips.setAll(this.getCapableShips());
        ICityHall cityHall = this.cityHallEngine.findCityHall(this.city.getCity());
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityHallOutriggerNotice", new Object[0], this.locale.getCurrentLocal()));
        int actionButtonX = 197;
        if (cityHall.getOutriggerContract().isPresent()) {
            String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.OutriggerNoticeDialog.outriggerPresent", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            this.getContent().add((Object)text);
            DecoratedText prevText = text;
            IOutriggerContract contract = (IOutriggerContract)cityHall.getOutriggerContract().get();
            IShip ship = contract.getOutrigger();
            IPlayer owner = (IPlayer)ship.getOwner();
            Object[] args = new Object[]{this.modelTranslator.getLocalDisplayNameWithArticle(ship.getShipType(), true), ship.getName(), this.modelTranslator.getLocalDisplayName(owner.getCareerLevel()), this.modelTranslator.getLocalDisplayName(owner.getRank()), owner.getName() + " " + owner.getLastName()};
            template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.OutriggerNoticeDialog.outriggerOwner", args, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            text.layoutYProperty().bind((ObservableValue)prevText.heightProperty().add((ObservableNumberValue)prevText.layoutYProperty()).add(24));
            this.getContent().add((Object)text);
            Image weaponIcon = this.imageLoader.getImage("icons/64/bombard-icon", 32.0, 32.0);
            Image healthIcon = this.imageLoader.getImage("icons/64/health-icon", 32.0, 32.0);
            Image sailorIcon = this.imageLoader.getImage("icons/64/sailor-icon", 32.0, 32.0);
            Table tableModel = new Table();
            TableHeader header = new TableHeader(3);
            header.add((ITableCell)new ControlTableCell((Node)new ImageView(weaponIcon)));
            header.add((ITableCell)new ControlTableCell((Node)new ImageView(healthIcon)));
            header.add((ITableCell)new ControlTableCell((Node)new ImageView(sailorIcon)));
            tableModel.setHeader(header);
            tableModel.setColumnWidth(new Integer[]{80, 80, 80});
            tableModel.setAligenment(0, HPos.CENTER);
            tableModel.setAligenment(1, HPos.CENTER);
            tableModel.setAligenment(2, HPos.CENTER);
            int strength = this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship);
            String key = null;
            key = strength % 2 != 0 ? (strength == 1 ? "ch.sahits.game.openpatrician.model.ship.impl.Ship.weaponStrengthOne" : "ch.sahits.game.openpatrician.model.ship.impl.Ship.weaponStrengthUneven") : "ch.sahits.game.openpatrician.model.ship.impl.Ship.weaponStrengthEven";
            template = this.messageSource.getMessage(key, new Object[]{strength /= 2}, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            TableRow row = new TableRow();
            row.add((ITableCell)new ControlTableCell((Node)text));
            int health = 100 - ship.getDamage();
            int sailors = ship.getNumberOfSailors();
            template = String.valueOf(health);
            text = this.textFactory.createDecoratedText(template, new HashMap());
            row.add((ITableCell)new ControlTableCell((Node)text));
            template = String.valueOf(sailors);
            text = this.textFactory.createDecoratedText(template, new HashMap());
            row.add((ITableCell)new ControlTableCell((Node)text));
            tableModel.add(row);
            GridPane grid = this.fxUtils.createGridPaneFromModel(tableModel);
            grid.getStyleClass().add((Object)"tableFont");
            grid.setLayoutX(100.0);
            grid.setLayoutY(227.0);
            this.getContent().add((Object)grid);
            template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.OutriggerNoticeDialog.weeklyRefund", new Object[]{ship.getName(), contract.getWeeklyRefund()}, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            text.setLayoutY(427.0);
            this.getContent().add((Object)text);
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.OutriggerNoticeDialog.discharge", new Object[0], this.locale.getCurrentLocal()));
            action.getStyleClass().add((Object)"actionButton");
            action.setOnAction(this.getAction(contract));
            action.setLayoutX(197.0);
            action.setLayoutY(603.0);
            action.setDisable(!this.capableShipPresent.get());
            this.getContent().addAll((Object[])new Node[]{action});
        } else {
            int minStrength = this.outriggerService.getRequiredWeaponStrength(this.city.getCity());
            int refund = this.outriggerService.getWeeklyReund(this.city.getCity());
            String key = null;
            key = minStrength % 2 != 0 ? (minStrength == 1 ? "ch.sahits.game.graphic.display.dialog.cityhall.OutriggerNoticeDialog.outriggerRequestOne" : "ch.sahits.game.graphic.display.dialog.cityhall.OutriggerNoticeDialog.outriggerRequestUneven") : "ch.sahits.game.graphic.display.dialog.cityhall.OutriggerNoticeDialog.outriggerRequestEven";
            String template = this.messageSource.getMessage(key, new Object[]{this.city.getCity().getName(), minStrength / 2, refund}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            this.getContent().add((Object)text);
            template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.OutriggerNoticeDialog.noShip", new Object[0], this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            text.setLayoutY(227.0);
            text.visibleProperty().bind((ObservableValue)this.capableShipPresent);
            this.getContent().add((Object)text);
            OpenPatricianSmallWaxButton previous = new OpenPatricianSmallWaxButton("<");
            previous.getStyleClass().add((Object)"actionButton");
            previous.setLayoutX(131.0);
            previous.setLayoutY(579.0);
            previous.setOnAction(this.createPreviousAction());
            previous.visibleProperty().bind((ObservableValue)this.enablePreviousNext);
            OpenPatricianSmallWaxButton next = new OpenPatricianSmallWaxButton(">");
            next.getStyleClass().add((Object)"actionButton");
            next.setLayoutX(325.0);
            next.setLayoutY(579.0);
            next.setOnAction(this.createNextAction());
            next.visibleProperty().bind((ObservableValue)this.enablePreviousNext);
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()));
            action.getStyleClass().add((Object)"actionButton");
            action.setOnAction(this.getAction(minStrength, refund));
            action.setLayoutX(197.0);
            action.setLayoutY(603.0);
            action.setDisable(!this.capableShipPresent.get());
            this.capableShipPresent.addListener((observable, oldFlag, newFlag) -> action.setDisable(newFlag == false));
            this.enablePreviousNext.addListener((observableValue, oldVBoolean, newValue) -> {
                next.setVisible(newValue == false);
                previous.setVisible(newValue == false);
            });
            this.getContent().addAll((Object[])new Node[]{previous, next, action});
        }
    }

    private EventHandler<MouseEvent> getAction(IOutriggerContract contract) {
        return mouseEvent -> {
            IShip ship = contract.getOutrigger();
            ship.setAvailable(true);
            this.city.getPlayersShips().add((Object)ship);
            this.cityHallEngine.findCityHall(this.city.getCity()).setOutriggerContract(Optional.empty());
            this.executeOnCloseButtonClicked();
        };
    }

    private EventHandler<MouseEvent> getAction(int minStrength, int refund) {
        return mouseEvent -> {
            IShip ship = (IShip)this.capableShips.get(this.currentIndex.get());
            OutriggerContract contract = new OutriggerContract(ship, minStrength, refund);
            ship.setAvailable(false);
            this.city.getPlayersShips().remove((Object)ship);
            Optional<OutriggerContract> optContract = Optional.of(contract);
            this.cityHallEngine.findCityHall(this.city.getCity()).setOutriggerContract(optContract);
            this.executeOnCloseButtonClicked();
        };
    }

    private EventHandler<MouseEvent> createNextAction() {
        return mouseEvent -> {
            if (this.currentIndex.get() == this.capableShips.size() - 1) {
                this.currentIndex.set(0);
            } else {
                this.currentIndex.set(this.currentIndex.get() + 1);
            }
        };
    }

    private EventHandler<MouseEvent> createPreviousAction() {
        return mouseEvent -> {
            if (this.currentIndex.get() == 0) {
                this.currentIndex.set(this.capableShips.size() - 1);
            } else {
                this.currentIndex.set(this.currentIndex.get() - 1);
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_BOARD);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return OutriggerNoticeDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<OutriggerNoticeDialog, Font> FONT = new CssMetaData<OutriggerNoticeDialog, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(OutriggerNoticeDialog control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(OutriggerNoticeDialog control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

