/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.loaner;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.engine.land.city.LoanerEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LoanerPaybackDialog
extends CloseButtonDialog {
    private final int BUTTON_X = 197;
    private final int BUTTON_Y = 603;
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray; -fx-text-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;  -fx-text-fill: black;";
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private LoanerEngine loanerEngine;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private LoanerService loanerService;
    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    @ObjectPropertyType(value=IDebt.class)
    private ObjectProperty<IDebt> selectedDebt = new SimpleObjectProperty(null);
    private VBox box;

    public LoanerPaybackDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        ICity city1 = this.city.getCity();
        this.loaner = (LoanerState)this.loanerService.findLoaner(city1);
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.repayLoan", new Object[0], this.locale.getCurrentLocal()));
        List debts = this.loanerEngine.findDebts((ILoaner)this.loaner, (IPlayer)this.city.getPlayer());
        this.box = new VBox(5.0);
        this.box.setLayoutX(30.0);
        this.box.setLayoutY(200.0);
        this.getContent().add((Object)this.box);
        if (debts.isEmpty()) {
            String header = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerPaybackDialog.debtFree", new Object[0], this.locale.getCurrentLocal());
            Text subHeading = new Text();
            subHeading.setText(header);
            subHeading.getStyleClass().add((Object)"dialogText");
            this.box.getChildren().add((Object)subHeading);
        } else {
            String header = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerPaybackDialog.subHeader", new Object[0], this.locale.getCurrentLocal());
            Text subHeading = new Text();
            subHeading.setText(header);
            this.box.getChildren().add((Object)subHeading);
            for (IDebt debt : debts) {
                int payback = this.calculatePaybacksum(debt);
                String cityName = city1.getName();
                DateTime dueDate1 = debt.getDueDate();
                String dueDate = this.modelTranslations.toDisplayString(dueDate1);
                String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerPaybackDialog.payback", new Object[]{payback, cityName, dueDate}, this.locale.getCurrentLocal());
                DecoratedText entry = this.textFactory.createDecoratedText(s, new HashMap());
                entry.setOnMouseReleased(mouseEvent -> {
                    this.selectedDebt.setValue((Object)debt);
                    this.deactivateAll();
                    entry.applyStyle(SELECTED_STYLE);
                });
                entry.applyStyle(DEFAULT_NON_SELECTED_STYLE);
                this.box.getChildren().add((Object)entry);
            }
            OpenPatricianLargeWaxButton acceptBtn = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerPaybackDialog.paybackBtn", new Object[0], this.locale.getCurrentLocal()));
            acceptBtn.getStyleClass().add((Object)"actionButton");
            acceptBtn.setLayoutX(197.0);
            acceptBtn.setLayoutY(603.0);
            acceptBtn.setDisable(true);
            this.selectedDebt.addListener((observableValue, oldDebt, newDebt) -> {
                if (newDebt != null) {
                    acceptBtn.setDisable(false);
                }
            });
            acceptBtn.setOnAction(this.createAcceptHandler());
            this.getContent().addAll((Object[])new Node[]{acceptBtn});
        }
    }

    private void deactivateAll() {
        for (Node node : this.box.getChildren()) {
            if (!(node instanceof DecoratedText)) continue;
            ((DecoratedText)node).applyStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    private int calculatePaybacksum(IDebt debt) {
        double totalDuration = debt.getTotalDuration();
        double currentDuration = debt.getLoanedDuration(this.date.getCurrentDate());
        if (currentDuration >= totalDuration) {
            return (int)(debt.getInterest() * (double)debt.getAmount());
        }
        int value = (int)(debt.getInterest() * (double)debt.getAmount() * currentDuration / totalDuration);
        return value;
    }

    private EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                IDebt debt;
                int debtTotal;
                ICompany company = LoanerPaybackDialog.this.city.getPlayer().getCompany();
                long cash = company.getCash();
                if (cash < (long)(debtTotal = LoanerPaybackDialog.this.calculatePaybacksum(debt = (IDebt)LoanerPaybackDialog.this.selectedDebt.get()))) {
                    LoanerPaybackDialog.this.getContent().remove((Object)LoanerPaybackDialog.this.box);
                    LoanerPaybackDialog.this.box = new VBox(5.0);
                    LoanerPaybackDialog.this.box.setLayoutX(30.0);
                    LoanerPaybackDialog.this.box.setLayoutY(200.0);
                    LoanerPaybackDialog.this.getContent().add(LoanerPaybackDialog.this.getContent().size() - 2, (Object)LoanerPaybackDialog.this.box);
                    String header = LoanerPaybackDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerPaybackDialog.noRepay", new Object[0], LoanerPaybackDialog.this.locale.getCurrentLocal());
                    Text subHeading = new Text();
                    subHeading.setText(header);
                    LoanerPaybackDialog.this.box.getChildren().add((Object)subHeading);
                } else {
                    debt.getCreditor().receiveSum((long)debtTotal);
                    company.updateCash((long)(-debtTotal));
                    LoanerPaybackDialog.this.loaner.getDebts().remove(debt);
                    LoanerPaybackDialog.this.executeOnCloseButtonClicked();
                }
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_LOANER);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

