/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.shipyard;

import ch.sahits.game.event.data.ShipyardOrderRepair;
import ch.sahits.game.graphic.display.dialog.shipyard.BaseShipyardDialog;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shipRepairDialog")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipRepairDialogV2
extends BaseShipyardDialog {
    @ObjectPropertyType(value=IShip.class)
    private ObjectProperty<IShip> currentShip = new SimpleObjectProperty((Object)this, "currentShip", null);
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private ShipService shipService;
    @Autowired
    private MessageSource messageSource;

    public ShipRepairDialogV2(ICityPlayerProxyJFX city) {
        super(city);
        if (city.getActiveShip() instanceof IShip) {
            IShip ship = (IShip)city.getActiveShip();
            this.currentShip.setValue((Object)ship);
        }
        if (this.currentShip.get() != null) {
            for (int i = 0; i < this.shipTypes.length; ++i) {
                if (this.shipTypes[i] != ((IShip)this.currentShip.get()).getShipType()) continue;
                this.currentShipTypeIndexProperty().set(i);
                break;
            }
        } else {
            this.currentShipTypeIndexProperty().set(0);
        }
    }

    @PostConstruct
    private void init() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipRepairDialogV2.title", new Object[0], this.locale.getCurrentLocal()));
        this.enablePreviousNext = this.dialogUtil.enableShipCatalogueForShips(this.city);
    }

    @Override
    protected EventHandler<MouseEvent> getAction() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ShipRepairDialogV2.this.city.getPlayersShips().remove(ShipRepairDialogV2.this.currentShip.get());
                ShipyardOrderRepair event = new ShipyardOrderRepair(ShipRepairDialogV2.this.getCity().getCityState().getShipyardState(), (IShip)ShipRepairDialogV2.this.currentShip.get(), ShipRepairDialogV2.this.city);
                ShipRepairDialogV2.this.clientServerEventBus.post((Object)event);
                ShipRepairDialogV2.this.getPlayer().getCompany().updateCash((long)(-ShipRepairDialogV2.this.calculateRepairCosts()));
                ShipRepairDialogV2.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected String getActionText() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipRepairDialogV2.repair", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected boolean hasShips() {
        if (this.city.getPlayersShips().size() > 0) {
            return this.city.getPlayersShips().stream().anyMatch(ship -> ship.isAvailable());
        }
        return false;
    }

    @Override
    protected Group createFooterText() {
        int costs = this.calculateRepairCosts();
        Group g = new Group();
        String t = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.totalSum", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("price", costs);
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(t, parameters);
        g.getChildren().add((Object)dt);
        return g;
    }

    private int calculateRepairCosts() {
        return this.shipService.calculateRepairCosts(this.getCity(), (IShip)this.currentShip.get());
    }

    @Override
    protected Table createMainTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(1);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{200});
        TableRow row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(((IShip)this.currentShip.get()).getName()));
        model.add(row);
        return model;
    }

    @Override
    protected Table createTopTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(4);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70});
        TableRow row = new TableRow();
        BarrelAmount capacityAmount = new BarrelAmount();
        capacityAmount.setAmount(Integer.valueOf(((IShip)this.currentShip.get()).getSize()));
        row.add((ITableCell)new ControlTableCell((Node)capacityAmount));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(100 - ((IShip)this.currentShip.get()).getDamage())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(((IShip)this.currentShip.get()).getNumberOfSailors())));
        row.add((ITableCell)new StaticTextTableCell("1"));
        model.add(row);
        return model;
    }

    @Override
    protected BooleanBinding actionEnabledBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return (long)ShipRepairDialogV2.this.calculateRepairCosts() < ShipRepairDialogV2.this.getPlayer().getCompany().getCash();
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> createNextAction() {
        return this.dialogUtil.createNextActionForShips(this.city, this.currentShip);
    }

    @Override
    protected EventHandler<MouseEvent> createPreviousAction() {
        return this.dialogUtil.createPreviousActionForShips(this.city, this.currentShip);
    }
}

