/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.graphic.event.task.ConcurrentReconciliation;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernConcurrentDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;

    public TavernConcurrentDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getConcurrent());
        this.setTitle(((IConcurrent)this.currentPerson.get()).getName());
    }

    @PostConstruct
    private void initializeDialog() {
        this.initializeButtons();
        IConcurrent concurrent = (IConcurrent)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernConcurrentDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", this.city.getPlayer().getLastName());
        parameters.put("concurrent", concurrent.getName());
        parameters.put("price", concurrent.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            IConcurrent concurrent = (IConcurrent)this.currentPerson.get();
            int minutes = this.rnd.nextInt(600);
            DateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
            this.taskFactory.getPostponedDisplayMessage(postMessage, "ch.sahits.game.graphic.display.dialog.TavernConcurrentDialog.acceptMessage", concurrent.getConcurrentName());
            ConcurrentReconciliation reconsialistation = this.taskFactory.getConcurrentReconciliation();
            this.eventHandlerFactory.getSinkConcurrentsShipOrder(concurrent.getConcurrentPlayer(), (IPlayer)this.city.getPlayer(), 20, concurrent.getPremium(), reconsialistation);
            this.taskFactory.getOpponentsOrder(concurrent.getConcurrentPlayer(), concurrent.getClientPlayer(), (IPlayer)this.city.getPlayer(), concurrent.getPremium() * 2);
            concurrent.leave();
            this.executeOnCloseButtonClicked();
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return false;
            }
        };
    }
}

