/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.data.CourierPatrolStateInternal;
import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernCourierDialog
extends TavernBaseSideRoomPersonDialog {
    private static final int AMOUNT = 3;
    @Autowired
    private Random rnd;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;

    public TavernCourierDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getCourier());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCourierDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCourierDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("city", this.city.getCity().getName());
        parameters.put("amount", 3);
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().add((Object)dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            if (!this.tavernDialogUtil.noShipWithEnoughCapacityAvailable(this.city, 3)) {
                for (IShip ship : this.city.getPlayersShips()) {
                    if (ship.getCapacity() < 30) continue;
                    ICourier courier = (ICourier)this.currentPerson.get();
                    ship.addPassenger((IPerson)courier);
                    CourierPatrolStateInternal patrolState = new CourierPatrolStateInternal(courier.getPremium(), courier.getDestinations());
                    IHumanPlayer player = this.city.getPlayer();
                    int minutes = this.rnd.nextInt(600);
                    DateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
                    String cityName = patrolState.nextDestination().get().getName();
                    this.taskFactory.getPostponedDisplayMessage(postMessage, "ch.sahits.game.graphic.display.dialog.TavernPatrolDialog.acceptMessage", ship.getName(), cityName);
                    DateTime firstDeadline = this.date.getCurrentDate().plusDays(6);
                    this.eventHandlerFactory.getNextCourierPatrolStationHanlder(ship, patrolState.nextDestination().get(), patrolState, (IPlayer)player, firstDeadline);
                    courier.leave();
                    this.executeOnCloseButtonClicked();
                    break;
                }
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){
            {
                if (TavernCourierDialog.this.city.getActiveShip() instanceof IShip) {
                    ((IShip)TavernCourierDialog.this.city.getActiveShip()).passengerPresentProperty();
                }
            }

            protected boolean computeValue() {
                return !(TavernCourierDialog.this.city.getActiveShip() instanceof IShip) || TavernCourierDialog.this.tavernDialogUtil.noShipWithEnoughCapacityAvailable(TavernCourierDialog.this.city, 3) || ((IShip)TavernCourierDialog.this.city.getActiveShip()).passengerPresentProperty().get();
            }
        };
    }
}

