/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernWarehouseTenantDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private TimedUpdatableTaskList list;

    public TavernWarehouseTenantDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getWarehouseTenant());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWarehouseTenantDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IWarehouseTenant tenant = (IWarehouseTenant)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWarehouseTenantDialog.dialog", new Object[]{tenant.getName()}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", tenant.getAmount());
        parameters.put("price", tenant.getRentPerWeek());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            IHumanPlayer player = this.city.getPlayer();
            final IWarehouseTenant tenant = (IWarehouseTenant)this.currentPerson.get();
            final ITradingOffice office = this.city.getPlayer().findTradingOffice(this.city.getCity());
            if (office != null) {
                office.setOccupiedSpace(office.getOccupiedSpace() + tenant.getAmount());
                int weeks = this.rnd.nextInt(15) + 5;
                DateTime currentDate = this.date.getCurrentDate();
                for (int i = 0; i < weeks; ++i) {
                    currentDate = currentDate.plusWeeks(1);
                    TimedTask task = new TimedTask((IPlayer)player, tenant){
                        final /* synthetic */ IPlayer val$player;
                        final /* synthetic */ IWarehouseTenant val$tenant;
                        {
                            this.val$player = iPlayer;
                            this.val$tenant = iWarehouseTenant;
                        }

                        public void run() {
                            this.val$player.getCompany().updateCash((long)this.val$tenant.getRentPerWeek());
                        }
                    };
                    task.setExecutionTime(currentDate);
                    this.list.add(task);
                }
                TimedTask task = new TimedTask(){

                    public void run() {
                        TavernWarehouseTenantDialog.this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.graphic.display.dialog.TavernWarehouseTenantDialog.acceptMessage", new Object[0]));
                        office.setOccupiedSpace(office.getOccupiedSpace() - tenant.getAmount());
                    }
                };
                task.setExecutionTime(this.date.getCurrentDate().plusWeeks(weeks));
                this.list.add(task);
                tenant.leave();
            }
            this.executeOnCloseButtonClicked();
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return TavernWarehouseTenantDialog.this.city.getPlayer().findTradingOffice(TavernWarehouseTenantDialog.this.city.getCity()) == null;
            }
        };
    }
}

