/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.gameplay.internal;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.gameplay.internal.ScenePolygonInitialzer;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CityHallScenePolygonInitializer
extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;

    public CityHallScenePolygonInitializer() {
        super("images/scene/cityhall");
    }

    @Override
    protected EventHandler<MouseEvent> createEventHandler(String name) {
        switch (name) {
            case "Floor": {
                return new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent arg0) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(CityHallScenePolygonInitializer.this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_MARKET);
                        CityHallScenePolygonInitializer.this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(CityHallScenePolygonInitializer.this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_HIDE);
                        CityHallScenePolygonInitializer.this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                    }
                };
            }
            case "Board": {
                return new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(CityHallScenePolygonInitializer.this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_BOARD);
                        CityHallScenePolygonInitializer.this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                    }
                };
            }
            case "Treasury": {
                return new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(CityHallScenePolygonInitializer.this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_TREASURY);
                        CityHallScenePolygonInitializer.this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                    }
                };
            }
            case "Aldermanoffice": {
                return new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(CityHallScenePolygonInitializer.this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_ALDERMAN);
                        CityHallScenePolygonInitializer.this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                    }
                };
            }
            case "Meetingroom": {
                return new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(CityHallScenePolygonInitializer.this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_MEETINGROOM);
                        CityHallScenePolygonInitializer.this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                    }
                };
            }
        }
        throw new IllegalStateException("Unhandled polygon action: " + name);
    }
}

