/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.javafx.control.DisplayMessageOverlayLabel;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.HANDLER})
public class DisplayMessageOverlay
extends VBox {
    private static final int DISPLAY_MESSAGE_FOR_SECONDS = 15;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="uiTimer")
    private ScheduledExecutorService uiTimer;
    @Autowired
    private TextSizingUtility sizeing;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations translator;

    @PostConstruct
    private void init() {
        this.clientEventBus.register((Object)this);
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleMessage(DisplayMessage message) {
        Object[] args = message.getMessageArguments();
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof EWare)) continue;
            args[i] = this.translator.getLocalDisplayName((EWare)args[i]);
        }
        String translatedMessage = this.messageSource.getMessage(message.getMessageKey(), args, this.locale.getCurrentLocal());
        final DisplayMessageOverlayLabel label = new DisplayMessageOverlayLabel(translatedMessage, this.sizeing);
        if (message.hasDialogTemplate()) {
            label.setLinkText(true);
            EventHandler<MouseEvent> openDialogEvenHandler = this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(message.getDialogTemplate()));
            label.setOnMouseReleased(openDialogEvenHandler);
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> {
                    FadeTransition ft = new FadeTransition(Duration.millis((double)2000.0), (Node)label);
                    ft.setFromValue(1.0);
                    ft.setToValue(0.0);
                    ft.setAutoReverse(false);
                    ft.setOnFinished(event -> DisplayMessageOverlay.this.getChildren().remove((Object)label));
                    ft.play();
                });
            }
        };
        this.uiTimer.schedule(task, 15L, TimeUnit.SECONDS);
        Platform.runLater(() -> this.getChildren().add(0, (Object)label));
    }

    private EventHandler<MouseEvent> createEventHandlerFromRunnable(final Runnable run) {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                run.run();
            }
        };
    }
}

