/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.event.data.ShipArrivesAtDestinationEvent;
import ch.sahits.game.event.data.ShipEntersPortEvent;
import ch.sahits.game.event.data.ShipLeavingPort;
import ch.sahits.game.event.data.ShipNearingPortEvent;
import ch.sahits.game.event.data.ShipPositionUpdateEvent;
import ch.sahits.game.event.data.SwitchCity;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.javafx.display.BaseMainGameImageView;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MultimapType;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.PathInterpolatorMap;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.sea.AStarGraphProvider;
import ch.sahits.game.openpatrician.engine.sea.IPathConverter;
import ch.sahits.game.openpatrician.engine.sea.LocationTracker;
import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.sea.ITravellingVessels;
import ch.sahits.game.openpatrician.model.sea.TravellingVessel;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.javafx.IJavaFXApplicationThreadExecution;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.JAVAFX, EClassCategory.UNRELEVANT_FOR_DESERIALISATION, EClassCategory.SINGLETON_BEAN})
@UniquePrototype
public class SeamapImageView
extends BaseMainGameImageView {
    private int visibleRange = 40;
    private static final int PATH_FADING_DELAY_MS = 5000;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ImageView imgView;
    private Pane shipCanvas;
    private final Rectangle clip;
    private final Rectangle scrollLeft;
    private final Rectangle scrollRight;
    private final Timeline slideLeftAnimation;
    private final Timeline slideRightAnimation;
    private double scale;
    @Autowired
    private IMap map;
    @Autowired
    private SeafaringService seafaringService;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private AStarGraphProvider aStarGraphService;
    @Autowired
    private IPathConverter pathConverter;
    @Autowired
    private ITravellingVessels vessels;
    @Autowired
    private PathInterpolatorMap interpolators;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private IDataImageLoader imageLoader;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="syncServerClientEventBus")
    private EventBus syncServerClientEventBus;
    @Autowired
    @Qualifier(value="clientEventBus")
    protected AsyncEventBus clientEventBus;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private Date date;
    @Autowired
    private ShipService shipService;
    @Autowired
    private LocationTracker locationTracker;
    @Autowired
    private IJavaFXApplicationThreadExecution threadExecution;
    @Autowired
    @Qualifier(value="uiTimer")
    private ScheduledExecutorService uiTimer;
    private Image mapImage;
    private final Rectangle slaveClip;
    private Point2D focus;
    @MultimapType(key=INavigableVessel.class, value=INavigableVessel.class)
    private Multimap<INavigableVessel, INavigableVessel> visibleShips = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());

    public SeamapImageView(Image mapImage, double width, double height, Point2D focus, double scale) {
        this.imgView = new ImageView();
        this.shipCanvas = new Pane();
        this.clip = new Rectangle(0.0, 0.0, width, height);
        Color slideColor = new Color(1.0, 1.0, 1.0, 0.1);
        this.slaveClip = new Rectangle(0.0, 0.0, width, height);
        this.scrollLeft = new Rectangle(0.0, 0.0, 50.0, height);
        this.scrollLeft.setFill((Paint)slideColor);
        this.scrollRight = new Rectangle(width - 50.0, 0.0, 50.0, height);
        this.scrollRight.setFill((Paint)slideColor);
        this.slideLeftAnimation = new Timeline();
        this.slideLeftAnimation.setCycleCount(-1);
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)50.0), event -> this.resetClipXPosition(this.clip.getX() - 5.0), new KeyValue[0]);
        this.slideLeftAnimation.getKeyFrames().add((Object)kf1);
        this.slideRightAnimation = new Timeline();
        this.slideRightAnimation.setCycleCount(-1);
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)50.0), event -> this.resetClipXPosition(this.clip.getX() + 5.0), new KeyValue[0]);
        this.slideRightAnimation.getKeyFrames().add((Object)kf2);
        this.mapImage = mapImage;
        this.focus = focus;
        this.scale = scale;
    }

    @PostConstruct
    private void init() {
        this.clip.xProperty().addListener((observable, oldValue, newValue) -> {
            this.slaveClip.setX(newValue.doubleValue());
            if (this.scrolledAllToTheLeft()) {
                this.slideLeftAnimation.stop();
                this.getChildren().remove((Object)this.scrollLeft);
            }
            if (this.scrolledAllToTheRight()) {
                this.slideRightAnimation.stop();
                this.getChildren().remove((Object)this.scrollRight);
            }
        });
        this.clip.yProperty().addListener((observable, oldValue, newValue) -> this.slaveClip.setY(newValue.doubleValue()));
        this.clip.widthProperty().addListener((observable, oldValue, newValue) -> {
            this.slaveClip.setWidth(newValue.doubleValue());
            this.scrollRight.setX(newValue.doubleValue() - this.scrollRight.getWidth());
        });
        this.clip.heightProperty().addListener((observable, oldValue, newValue) -> {
            this.slaveClip.setHeight(newValue.doubleValue());
            this.scrollLeft.setHeight(newValue.doubleValue());
            this.scrollRight.setHeight(newValue.doubleValue());
        });
        this.resetImage(this.mapImage, this.slaveClip.getWidth(), this.slaveClip.getHeight(), this.scale);
        this.imgView.setClip((Node)this.clip);
        this.shipCanvas.setClip((Node)this.slaveClip);
        this.shipCanvas.setMouseTransparent(true);
        this.focusOnPoint(this.focus);
        this.imgView.addEventHandler(MouseEvent.MOUSE_RELEASED, this::handleMouseClick);
        this.scrollLeft.setOnMouseEntered(evt -> {
            if (this.scrolledAllToTheRight() && !this.getChildren().contains((Object)this.scrollRight)) {
                this.getChildren().add((Object)this.scrollRight);
            }
            this.slideLeftAnimation.play();
        });
        this.scrollLeft.setOnMouseExited(evt -> this.slideLeftAnimation.stop());
        this.scrollRight.setOnMouseEntered(evt -> {
            if (this.scrolledAllToTheLeft() && !this.getChildren().contains((Object)this.scrollLeft)) {
                this.getChildren().add((Object)this.scrollLeft);
            }
            this.slideRightAnimation.play();
        });
        this.scrollRight.setOnMouseExited(evt -> this.slideRightAnimation.stop());
        if (!this.scrolledAllToTheLeft()) {
            this.getChildren().add((Object)this.scrollLeft);
        }
        if (!this.scrolledAllToTheRight()) {
            this.getChildren().add((Object)this.scrollRight);
        }
        this.initializeVisibleShips();
        this.clientServerEventBus.register((Object)this);
        this.syncServerClientEventBus.register((Object)this);
    }

    private void initializeVisibleShips() {
        IHumanPlayer player = this.viewState.getPlayer();
        for (INavigableVessel ship : player.getSelectableVessels()) {
            this.addVisibleVessel(ship, player);
        }
    }

    @VisibleForTesting
    void addVisibleVessel(INavigableVessel ship, IHumanPlayer player) {
        List visibleVessels = this.locationTracker.getShipsInSegments(ship.getLocation(), this.visibleRange);
        for (INavigableVessel visibleVessel : visibleVessels) {
            this.addSingleVisibleVessel(ship, player, visibleVessel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSingleVisibleVessel(INavigableVessel ship, IHumanPlayer player, INavigableVessel visibleVessel) {
        if (!this.isInCity(visibleVessel.getLocation()) && !this.isInCity(ship.getLocation()) && !visibleVessel.getOwner().equals(player) && this.areVisibleToEachOther(visibleVessel, ship)) {
            Multimap<INavigableVessel, INavigableVessel> multimap = this.visibleShips;
            synchronized (multimap) {
                if (!this.visibleShips.containsKey((Object)visibleVessel) || !this.visibleShips.containsEntry((Object)visibleVessel, (Object)ship)) {
                    this.visibleShips.put((Object)visibleVessel, (Object)ship);
                }
            }
            this.drawShipOnMap(visibleVessel);
        }
    }

    @PreDestroy
    void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        this.syncServerClientEventBus.unregister((Object)this);
    }

    private boolean isInCity(Point2D location) {
        return this.map.getCityCoordinates().stream().anyMatch(coord -> coord.equals((Object)location));
    }

    private void handleMouseClick(final MouseEvent evt) {
        block9: {
            ICity city;
            block10: {
                INavigableVessel vessel;
                block11: {
                    boolean travelTo = evt.getButton().equals((Object)MouseButton.PRIMARY);
                    double unscaledX = Math.round(evt.getX() / this.scale);
                    double unscaledY = Math.round(evt.getY() / this.scale);
                    city = this.findCity(unscaledX, unscaledY);
                    if (travelTo && (travelTo = this.viewState.getCurrentCityProxy().isPresent())) {
                        if (this.viewState.getCurrentCityProxy().get().getCity().equals(city)) {
                            travelTo = false;
                        } else {
                            boolean bl = travelTo = this.viewState.getCurrentCityProxy().get().getActiveShip() != null;
                        }
                    }
                    if (!travelTo) break block10;
                    vessel = this.viewState.getCurrentCityProxy().get().getActiveShip();
                    if (!(vessel instanceof IConvoy) || !((IConvoy)vessel).isPublicConvoy()) break block11;
                    TimedTask task = new TimedTask(){
                        {
                            this.setExecutionTime(SeamapImageView.this.date.getCurrentDate().plusDays(5));
                        }

                        public void run() {
                            SeamapImageView.this.travelToDestination(evt.getX(), evt.getY(), city, vessel);
                        }
                    };
                    this.taskList.add(task);
                    break block9;
                }
                if (!this.shipService.checkNumberOfSailors(vessel)) break block9;
                this.travelToDestination(evt.getX(), evt.getY(), city, vessel);
                break block9;
            }
            if (city != null) {
                List office = city.findBuilding(ITradingOffice.class, Optional.of(this.viewState.getPlayer()));
                List ships = this.viewState.getPlayer().getFleet();
                if (!office.isEmpty()) {
                    this.switchToCity(city);
                } else {
                    for (IShip ship : ships) {
                        if (!ship.getLocation().equals((Object)city.getCoordinates())) continue;
                        this.switchToCity(city);
                        break;
                    }
                }
            } else {
                double x = evt.getX();
                double y = evt.getY();
                for (Node node : this.shipCanvas.getChildren()) {
                    if (!(node instanceof ImageView) || !node.getBoundsInParent().contains(x, y)) continue;
                    String id = node.getId();
                    List fleet = this.viewState.getPlayer().getSelectableVessels();
                    Optional vessel = this.shipService.findShipByUuid(fleet, id);
                    if (!vessel.isPresent()) continue;
                    this.viewState.getCurrentCityProxy().get().activateShip((INavigableVessel)vessel.get());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void travelToDestination(double x, double y, ICity destinationCity, INavigableVessel vessel) {
        double unscaledX = Math.round(x / this.scale);
        double unscaledY = Math.round(y / this.scale);
        ICity sourceCity = this.findCity(vessel.getLocation().getX(), vessel.getLocation().getY());
        List path = new ArrayList();
        if (destinationCity != null) {
            path = this.seafaringService.travelTo(vessel, destinationCity.getCoordinates());
        } else {
            Point2D destination = new Point2D(unscaledX, unscaledY);
            if (this.aStarGraphService.isOnSea(destination)) {
                path = this.seafaringService.travelTo(vessel, destination);
            }
        }
        this.drawPath(vessel, path);
        PathInterpolatorMap pathInterpolatorMap = this.interpolators;
        synchronized (pathInterpolatorMap) {
            if (destinationCity != null) {
                this.interpolators.get((Object)vessel).setDestinationCity(true);
            } else {
                this.interpolators.get((Object)vessel).setDestinationCity(false);
            }
            if (sourceCity != null) {
                this.interpolators.get((Object)vessel).setSourceCity(true);
            } else {
                this.interpolators.get((Object)vessel).setSourceCity(false);
            }
        }
        this.vessels.getTravellingVessel(vessel).setDisplayVessel(true);
        if (sourceCity == null && this.viewState.getCurrentCityProxy().isPresent()) {
            this.viewState.getCurrentCityProxy().get().leave(vessel);
        }
    }

    private void drawPath(INavigableVessel vessel, List<Point2D> path) {
        if (path != null) {
            this.clearLines();
            Path p = this.pathConverter.createPath(vessel, path, this.scale);
            this.drawPathOnMap(vessel, path, p);
        }
    }

    private void drawPathOnMap(INavigableVessel vessel, List<Point2D> path, final Path p) {
        this.shipCanvas.getChildren().add((Object)p);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> {
                    FadeTransition ft = new FadeTransition(Duration.millis((double)2000.0), (Node)p);
                    ft.setFromValue(1.0);
                    ft.setToValue(0.0);
                    ft.setAutoReverse(false);
                    ft.setOnFinished(event -> SeamapImageView.this.shipCanvas.getChildren().remove((Object)p));
                    ft.play();
                });
            }
        };
        this.uiTimer.schedule(task, 5000L, TimeUnit.MILLISECONDS);
        Image shipIcon = this.getShipIcon(vessel);
        int scaleXFactor = 1;
        if (path.get(0).getX() < path.get(path.size() - 1).getX()) {
            scaleXFactor = -1;
        }
        ImageView view = new ImageView(shipIcon);
        view.addEventFilter(ActionEvent.ANY, event -> {
            this.logger.debug("Activate ship {}", new Object[]{vessel.getName()});
            this.viewState.getCurrentCityProxy().get().activateShip(vessel);
        });
        view.setScaleX(0.5 * (double)scaleXFactor);
        view.setScaleY(0.5);
        view.setId(vessel.getUuid());
        this.updateShipPosition(vessel, shipIcon, view);
        this.threadExecution.execute(() -> this.updateShipIcon(vessel, view));
    }

    private void drawShipOnMap(INavigableVessel vessel) {
        Image shipIcon = this.getShipIcon(vessel);
        ImageView view = new ImageView(shipIcon);
        view.setScaleX(0.5);
        view.setScaleY(0.5);
        view.setId(vessel.getUuid());
        this.updateShipPosition(vessel, shipIcon, view);
        if (this.threadExecution.isFxApplicationThread()) {
            this.updateShipIcon(vessel, view);
        } else {
            this.threadExecution.execute(() -> this.updateShipIcon(vessel, view));
        }
    }

    private void updateShipIcon(INavigableVessel vessel, ImageView view) {
        ImageView oldView = this.findImageView(vessel);
        if (oldView != null) {
            this.shipCanvas.getChildren().remove((Object)oldView);
        }
        this.shipCanvas.getChildren().add((Object)view);
    }

    private void drawExistingPath(TravellingVessel vessel) {
        INavigableVessel ship = vessel.getVessel();
        Path path = vessel.getDrwawablePath();
        List pointedPath = vessel.getCalculatablePath();
        this.clearLines();
        this.drawPathOnMap(ship, pointedPath, path);
    }

    private void updateShipPosition(INavigableVessel vessel, Image shipIcon, ImageView view) {
        Point2D location = vessel.getLocation();
        double x = location.getX() * this.scale;
        double y = location.getY() * this.scale;
        this.threadExecution.execute(() -> {
            view.setLayoutX(x - shipIcon.getWidth() / 2.0);
            view.setLayoutY(y - shipIcon.getHeight() / 2.0);
            this.logger.trace("Update ship {} position to {},{}", new Object[]{vessel.getName(), view.getLayoutX(), view.getLayoutY()});
        });
    }

    private ImageView findImageView(INavigableVessel vessel) {
        String id = vessel.getUuid();
        for (Node node : this.shipCanvas.getChildrenUnmodifiable()) {
            if (!(node instanceof ImageView) || !node.getId().equals(id)) continue;
            return (ImageView)node;
        }
        return null;
    }

    private Image getShipIcon(INavigableVessel vessel) {
        if (vessel instanceof IShip) {
            switch (((IShip)vessel).getShipType()) {
                case COG: {
                    return this.imageLoader.getImage("icons/64/cog_icon");
                }
                case CRAYER: {
                    return this.imageLoader.getImage("icons/64/crayer_icon");
                }
                case HOLK: {
                    return this.imageLoader.getImage("icons/64/holk_icon");
                }
                case SNAIKKA: {
                    return this.imageLoader.getImage("icons/64/schnikka_icon");
                }
            }
        } else {
            IConvoy convoy = (IConvoy)vessel;
            return this.getShipIcon((INavigableVessel)convoy.getOrlegShip());
        }
        return null;
    }

    private void clearLines() {
        Iterator iterator = this.shipCanvas.getChildren().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof Shape)) continue;
            iterator.remove();
        }
    }

    private void switchToCity(ICity city) {
        this.clientEventBus.post((Object)new SwitchCity(city));
    }

    private ICity findCity(double unscaledX, double unscaledY) {
        Point2D p = new Point2D(unscaledX, unscaledY);
        for (ICity city : this.map.getCities()) {
            double distance = p.distance(city.getCoordinates());
            if (!(distance <= 20.0)) continue;
            return city;
        }
        return null;
    }

    private boolean scrolledAllToTheLeft() {
        return this.clip.getX() <= 0.0;
    }

    private boolean scrolledAllToTheRight() {
        return this.clip.getX() >= this.imgView.getImage().getWidth() - this.clip.getWidth();
    }

    private void focusOnPoint(Point2D focus) {
        double totalwidth = this.imgView.getImage().getWidth();
        double focusX = focus.getX();
        double clipX = this.clip.getX();
        double clipWidth = this.clip.getWidth();
        double centerX = clipX + clipWidth / 2.0;
        if (!(clipX == 0.0 && focusX < centerX || clipX + clipWidth >= totalwidth)) {
            double x = Math.min(focusX - clipWidth / 2.0, totalwidth - clipWidth);
            this.resetClipXPosition(x);
        }
    }

    private void resetClipXPosition(double x) {
        if (x < 0.0) {
            x = 0.0;
        }
        if (x > this.imgView.getImage().getWidth()) {
            x = this.imgView.getImage().getWidth();
        }
        this.imgView.setLayoutX(-x);
        this.shipCanvas.setLayoutX(-x);
        this.clip.setX(x);
        this.logger.trace("Set clip position={}, view and ship canvas layout: {}", new Object[]{x, -x});
    }

    public void resetImage(Image mapImage, double width, double height, double scale) {
        double oldScale = this.scale;
        this.scale = scale;
        this.imgView.setImage(mapImage);
        this.shipCanvas.setMaxWidth(mapImage.getWidth());
        this.shipCanvas.setMinWidth(mapImage.getWidth());
        this.shipCanvas.setMaxHeight(mapImage.getHeight());
        this.shipCanvas.setMinHeight(mapImage.getHeight());
        this.getChildren().removeAll((Object[])new Node[]{this.imgView, this.shipCanvas});
        double oldWidth = this.clip.getWidth();
        boolean widthChange = oldWidth != width;
        boolean heightChange = this.clip.getHeight() != height;
        double x = Math.max((width - mapImage.getWidth()) / 2.0, 0.0);
        double y = Math.max((height - mapImage.getHeight()) / 2.0, 0.0);
        if (!heightChange) {
            this.imgView.setLayoutX(x);
            this.shipCanvas.setLayoutX(x);
        }
        this.imgView.setLayoutY(y);
        this.shipCanvas.setLayoutY(y);
        double focuspoint = this.clip.getX() + oldWidth / 2.0;
        double xx = Math.max(0.0, focuspoint - width / 2.0);
        this.resetClipXPosition(xx);
        Iterator iterator = this.shipCanvas.getChildren().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof Circle)) continue;
            iterator.remove();
        }
        this.drawShipsInCities(mapImage, scale, xx);
        for (INavigableVessel vessel : this.vessels) {
            TravellingVessel traveling = this.vessels.getTravellingVessel(vessel);
            if (!traveling.getDisplayVessel()) continue;
            this.drawExistingPath(traveling);
        }
        this.redrawPath(oldScale);
        this.clip.setWidth(width);
        this.clip.setHeight(height);
        this.getChildren().add(0, (Object)this.shipCanvas);
        this.getChildren().add(0, (Object)this.imgView);
        this.scrollRight.setX(width - this.scrollRight.getWidth());
    }

    private void drawShipsInCities(Image mapImage, double scale, double x) {
        for (ICity city : this.map.getCities()) {
            List ships;
            if (!(city.getCoordinates().getX() >= x) || !(city.getCoordinates().getX() <= x + mapImage.getWidth()) || (ships = this.viewState.getPlayer().findShips(city)).isEmpty()) continue;
            this.drawShipPresenceInCity(city);
        }
    }

    private void drawShipPresenceInCity(ICity city) {
        int radius = 8;
        int cityX = (int)Math.rint(city.getCoordinates().getX());
        int cityY = (int)Math.rint(city.getCoordinates().getY());
        Circle c = new Circle((double)cityX * this.scale, (double)cityY * this.scale, (double)radius * this.scale, (Paint)Color.WHITE);
        this.shipCanvas.getChildren().add((Object)c);
    }

    @Subscribe
    public void handleShipLeavesCity(ShipLeavingPort event) {
        List ships;
        ICity city = event.getCity();
        IShipOwner owner = event.getShip().getOwner();
        if (owner instanceof IHumanPlayer && owner.equals(this.viewState.getPlayer()) && (ships = ((IHumanPlayer)owner).findShips(city)).isEmpty()) {
            double cityX = (double)((int)Math.rint(city.getCoordinates().getX())) * this.scale;
            double cityY = (double)((int)Math.rint(city.getCoordinates().getY())) * this.scale;
            Iterator iterator = this.shipCanvas.getChildren().iterator();
            while (iterator.hasNext()) {
                Circle c;
                Node node = (Node)iterator.next();
                if (!(node instanceof Circle) || (c = (Circle)node).getCenterX() != cityX || c.getCenterY() != cityY) continue;
                Platform.runLater(() -> iterator.remove());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handelLoadedNewGame(GameStateChange event) {
        if (event.getStatusChange() == EGameStatusChange.GAME_LOADED) {
            Multimap<INavigableVessel, INavigableVessel> multimap = this.visibleShips;
            synchronized (multimap) {
                this.visibleShips.clear();
                this.initializeVisibleShips();
            }
        }
    }

    private void redrawPath(double oldScale) {
        double scaleCorrection = 1.0 / oldScale;
        double scale = this.scale * scaleCorrection;
        this.logger.debug("Rescale path from {} to {}, which is a correction of {}", new Object[]{oldScale, this.scale, scale});
        for (Node node : this.shipCanvas.getChildren()) {
            if (!(node instanceof Path)) continue;
            for (PathElement pathElement : ((Path)node).getElements()) {
                this.rescale(pathElement, scale);
            }
        }
    }

    private void rescale(MoveTo pathElement, double scale) {
        double value = pathElement.getX() * scale;
        pathElement.setX(value);
        value = pathElement.getY() * scale;
        pathElement.setY(value);
    }

    private void rescale(CubicCurveTo pathElement, double scale) {
        double value = pathElement.getX() * scale;
        pathElement.setX(value);
        value = pathElement.getY() * scale;
        pathElement.setY(value);
        value = pathElement.getControlX1() * scale;
        pathElement.setControlX1(value);
        value = pathElement.getControlY1() * scale;
        pathElement.setControlY1(value);
        value = pathElement.getControlX2() * scale;
        pathElement.setControlX2(value);
        value = pathElement.getControlY2() * scale;
        pathElement.setControlY2(value);
    }

    private void rescale(PathElement pathElement, double scale) {
        if (pathElement instanceof MoveTo) {
            this.rescale((MoveTo)pathElement, scale);
        } else if (pathElement instanceof CubicCurveTo) {
            this.rescale((CubicCurveTo)pathElement, scale);
        } else {
            throw new IllegalStateException("Rescaling for " + pathElement.getClass().getName() + " is not implemented");
        }
    }

    @Subscribe
    public void handleShipPositionUpdate(ShipPositionUpdateEvent event) {
        INavigableVessel vessel = event.getShip();
        TravellingVessel ship = this.vessels.getTravellingVessel(vessel);
        if (vessel.getOwner().equals(this.viewState.getPlayer())) {
            Preconditions.checkNotNull((Object)ship, (Object)("The travelling vessel instance for " + vessel.getName() + " of " + vessel.getOwner().getName() + " " + vessel.getOwner().getLastName() + " could not be found"));
        }
        if (ship != null) {
            this.threadExecution.execute(() -> {
                if (ship != null) {
                    ImageView icon = this.findImageView(vessel);
                    if (icon != null) {
                        Image shipIcon = icon.getImage();
                        this.updateShipPosition(vessel, shipIcon, icon);
                    } else {
                        this.logger.trace("Failed to find vessel with uuid {}", new Object[]{vessel.getUuid()});
                    }
                }
                this.handleVisibilityShips(vessel);
            });
        } else {
            this.logger.debug("Ship ship update for {} as ship is not a traveling vessel", new Object[]{vessel.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleVisibilityShips(INavigableVessel vessel) {
        IHumanPlayer player = this.viewState.getPlayer();
        TravellingVessel ship = this.vessels.getTravellingVessel(vessel);
        HashSet<INavigableVessel> noLongerVisibleVessels = new HashSet<INavigableVessel>();
        if (vessel.getOwner().equals(player)) {
            Multimap<INavigableVessel, INavigableVessel> multimap = this.visibleShips;
            synchronized (multimap) {
                HashSet vessels = new HashSet(this.visibleShips.keySet());
                for (INavigableVessel visibleVessel : vessels) {
                    Collection visibleVessels = this.visibleShips.get((Object)visibleVessel);
                    if (visibleVessels == null || !visibleVessels.contains(vessel)) continue;
                    this.checkVisiblityAndUpdate(vessel, noLongerVisibleVessels, visibleVessel);
                }
            }
            this.addVisibleVessel(vessel, player);
        } else {
            Multimap<INavigableVessel, INavigableVessel> multimap = this.visibleShips;
            synchronized (multimap) {
                if (this.visibleShips.containsKey((Object)vessel)) {
                    ArrayList seenByVessels = new ArrayList(this.visibleShips.get((Object)vessel));
                    for (INavigableVessel visiblePlayerVessel : seenByVessels) {
                        this.checkVisiblityAndUpdate(visiblePlayerVessel, noLongerVisibleVessels, vessel);
                    }
                }
            }
            List playersVessels = player.getSelectableVessels();
            for (INavigableVessel playersVessel : playersVessels) {
                if (!this.areVisibleToEachOther(playersVessel, vessel)) continue;
                if (this.visibleShips.containsKey((Object)vessel)) {
                    if (this.visibleShips.get((Object)vessel).contains(playersVessel)) continue;
                    this.addSingleVisibleVessel(playersVessel, player, vessel);
                    continue;
                }
                this.addSingleVisibleVessel(playersVessel, player, vessel);
            }
        }
        this.removeNoLongerVisibleVessels(noLongerVisibleVessels);
    }

    private void removeNoLongerVisibleVessels(Set<INavigableVessel> noLongerVisibleVessels) {
        for (INavigableVessel v : noLongerVisibleVessels) {
            ImageView oldView = this.findImageView(v);
            if (oldView == null) continue;
            this.shipCanvas.getChildren().remove((Object)oldView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVisiblityAndUpdate(INavigableVessel vessel, Set<INavigableVessel> noLongerVisibleVessels, INavigableVessel visibleVessel) {
        if (!this.areVisibleToEachOther(visibleVessel, vessel)) {
            Multimap<INavigableVessel, INavigableVessel> multimap = this.visibleShips;
            synchronized (multimap) {
                this.visibleShips.remove((Object)visibleVessel, (Object)vessel);
            }
            noLongerVisibleVessels.add(visibleVessel);
        }
    }

    private boolean areVisibleToEachOther(INavigableVessel vessel1, INavigableVessel vessel2) {
        double distance = vessel1.getLocation().distance(vessel2.getLocation());
        return distance <= (double)this.visibleRange;
    }

    @Subscribe
    public void handleShipReachesDestination(ShipArrivesAtDestinationEvent event) {
        INavigableVessel vessel = event.getShip();
        TravellingVessel ship = this.vessels.getTravellingVessel(vessel);
        Platform.runLater(() -> this.shipCanvas.getChildren().remove((Object)ship.getDrwawablePath()));
    }

    @Subscribe
    public void handleShipNearsPort(ShipNearingPortEvent event) {
        INavigableVessel vessel = event.getShip();
        TravellingVessel ship = this.vessels.getTravellingVessel(vessel);
        if (ship != null) {
            if (ship.getDisplayVessel()) {
                this.threadExecution.execute(() -> {
                    ImageView icon = this.findImageView(vessel);
                    if (icon != null) {
                        this.shipCanvas.getChildren().remove((Object)icon);
                        ship.setDisplayVessel(false);
                    }
                });
                Set<INavigableVessel> noLongerVisible = this.removeVisibleVessel(vessel);
                for (INavigableVessel v : noLongerVisible) {
                    this.logger.debug("The ship {} is no longer visible", new Object[]{v.getName()});
                }
                Platform.runLater(() -> this.removeNoLongerVisibleVessels(noLongerVisible));
            }
        } else {
            this.logger.debug("Ship ship nearing port for {} as ship is not a traveling vessel", new Object[]{vessel.getName()});
        }
    }

    @Subscribe
    public void handeShipReachesPort(ShipEntersPortEvent event) {
        ICity city = event.getCity();
        IShipOwner owner = event.getShip().getOwner();
        Platform.runLater(() -> {
            List ships;
            if (owner instanceof IHumanPlayer && owner.equals(this.viewState.getPlayer()) && (ships = ((IHumanPlayer)owner).findShips(city)).size() == 1) {
                this.drawShipPresenceInCity(city);
            }
        });
    }

    public void removeShipIcons() {
        Iterator iterator = this.shipCanvas.getChildren().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof ImageView)) continue;
            iterator.remove();
        }
    }

    private Set<INavigableVessel> removeVisibleVessel(INavigableVessel vessel) {
        HashSet<INavigableVessel> noLongerVisibile = new HashSet<INavigableVessel>();
        HashSet keys = new HashSet(this.visibleShips.keySet());
        for (INavigableVessel key : keys) {
            if (key.equals(vessel)) {
                Collection vessels = this.visibleShips.removeAll((Object)key);
                noLongerVisibile.addAll(vessels);
                continue;
            }
            this.visibleShips.remove((Object)key, (Object)vessel);
            if (!this.visibleShips.get((Object)key).isEmpty()) continue;
            noLongerVisibile.addAll(this.visibleShips.removeAll((Object)key));
            noLongerVisibile.add(key);
        }
        return noLongerVisibile;
    }
}

