/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display;

import ch.sahits.game.event.data.NewGameClient;
import ch.sahits.game.event.data.SwitchCity;
import ch.sahits.game.graphic.display.CheatKeyEventListener;
import ch.sahits.game.graphic.display.EViewState;
import ch.sahits.game.graphic.display.model.CityPlayerProxyJFX;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.OptionalType;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.persistence.IPostLoadOperation;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ClientViewState
implements IPostLoadOperation {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    @ObjectPropertyType(value=EViewState.class)
    private ObjectProperty<EViewState> state = new SimpleObjectProperty((Object)EViewState.CITY);
    @OptionalType(value=ICityPlayerProxyJFX.class)
    private Optional<ICityPlayerProxyJFX> currentCityProxy;
    private IHumanPlayer player;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    protected AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;

    @PostConstruct
    private void initEventBus() {
        this.clientServerEventBus.register((Object)this);
        this.clientEventBus.register((Object)this);
        try {
            CheatKeyEventListener listener = (CheatKeyEventListener)this.context.getBean(CheatKeyEventListener.class);
            listener.setViewState(this);
            listener.setContext(this.context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @PreDestroy
    private void unregister() {
        this.logger.debug("Unregister event bus in PreDestroy");
        this.clientServerEventBus.unregister((Object)this);
        this.clientEventBus.unregister((Object)this);
    }

    @Subscribe
    public void initializeState(NewGameClient newGameDTO) {
        this.player = newGameDTO.getPlayer();
        this.state.setValue((Object)EViewState.CITY);
        IShip activeShip = null;
        for (IShip ship : this.player.getFleet()) {
            if (!ship.isAvailable()) continue;
            activeShip = ship;
            break;
        }
        ICityPlayerProxyJFX proxy = (ICityPlayerProxyJFX)this.context.getBean("cityPlayerProxy", new Object[]{this.player.getHometown(), this.player, activeShip});
        this.currentCityProxy = Optional.of(proxy);
    }

    @Subscribe
    public void handleSwitchToCity(SwitchCity event) {
        if (this.currentCityProxy.isPresent() && !event.getToCity().equals(this.currentCityProxy.get().getCity())) {
            ICityPlayerProxyJFX proxy = this.currentCityProxy.get();
            ICity city = event.getToCity();
            proxy.setCity(city);
            proxy.getPlayersNavalVessels().clear();
            List ships = proxy.getPlayer().findShips(city);
            proxy.getPlayersNavalVessels().addAll((Collection)ships);
            if (!ships.isEmpty()) {
                proxy.activateShip((INavigableVessel)ships.get(0));
            }
        }
    }

    public EViewState getState() {
        return (EViewState)((Object)this.state.get());
    }

    public ObjectProperty<EViewState> stateProperty() {
        return this.state;
    }

    public void setState(EViewState state) {
        this.state.set((Object)state);
    }

    public void postLoad() {
        this.state.setValue((Object)EViewState.CITY);
        PlayerList players = (PlayerList)this.context.getBean(PlayerList.class);
        for (IPlayer curPlayer : players) {
            if (!(curPlayer instanceof IHumanPlayer)) continue;
            this.player = (IHumanPlayer)curPlayer;
            break;
        }
        CityPlayerProxyJFX proxy = (CityPlayerProxyJFX)this.context.getBean("cityPlayerProxy", new Object[]{this.player.getHometown(), this.player, null});
        this.currentCityProxy = Optional.of(proxy);
        proxy.postLoad();
    }

    public Optional<ICityPlayerProxyJFX> getCurrentCityProxy() {
        return this.currentCityProxy;
    }

    public IHumanPlayer getPlayer() {
        return this.player;
    }
}

