/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.event;

import ch.sahits.game.graphic.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.FireState;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import javafx.geometry.Pos;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class FireDialog
extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    private FireState state;

    public FireDialog(FireState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = this.modelTranslations.toDisplayString(this.state.getDate());
        this.addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation(), letterDate});
        this.addVerticalSpacer(20);
        this.addDecoratedText("ch.sahits.game.graphic.display.dialog.event.FireDialog.fire", "fire", this.state.getLocation(), this.state.getDestroyedBuildings(), this.state.getDeathtoll());
        if (this.state.getKilledSpouse().isPresent()) {
            ISpouseData spouse = (ISpouseData)this.state.getKilledSpouse().get();
            this.addDecoratedText("ch.sahits.game.graphic.display.dialog.event.FireDialog.wiveDeath", "wiveDeath", spouse.getName(), spouse.getLastName());
        }
    }
}

