/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.event;

import ch.sahits.game.graphic.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.SocialAdvancementDeficitState;
import javafx.geometry.Pos;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class SocialAdvancementDeficitDialog
extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    private SocialAdvancementDeficitState state;

    public SocialAdvancementDeficitDialog(SocialAdvancementDeficitState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = this.modelTranslations.toDisplayString(this.state.getDate());
        this.addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation(), letterDate});
        this.addVerticalSpacer(20);
        if (this.state.isReputation() && this.state.isMoney()) {
            this.addDecoratedText("ch.sahits.game.graphic.display.dialog.event.SocialAdvancementDeficitDialog.missingReputationAndWealth", "missingReputationAndWealth", this.state.getLocation());
        } else if (this.state.isMoney()) {
            this.addDecoratedText("ch.sahits.game.graphic.display.dialog.event.SocialAdvancementDeficitDialog.missingMoney", "missingMoney", this.state.getLocation());
        } else {
            this.addDecoratedText("ch.sahits.game.graphic.display.dialog.event.SocialAdvancementDeficitDialog.missingReputation", "missingReputation", this.state.getLocation());
        }
    }
}

