/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.guild;

import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.guild.GuildSettings;
import ch.sahits.game.openpatrician.model.city.guild.IMediterreanMap;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class GuildMediterraneanMapDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private GuildSettings guildSettings;
    @Autowired
    private IImageUtilities imageUtilities;

    public GuildMediterraneanMapDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildMediterraneanMapDialog.title", new Object[0], this.locale.getCurrentLocal()));
        IMediterreanMap map = this.guildSettings.getMediterreanMap();
        Image image = this.imageUtilities.createMediterraneanMap((IPlayer)this.city.getPlayer(), map);
        ImageView imgView = new ImageView(image);
        imgView.setId("mediterraneanMap");
        imgView.setFitWidth(458.0);
        imgView.setPreserveRatio(true);
        VBox box = new VBox(new Node[]{imgView});
        box.setLayoutX(30.0);
        box.setLayoutY(127.0);
        this.getContent().add((Object)box);
    }
}

