/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.shipyard;

import ch.sahits.game.graphic.display.dialog.shipyard.BaseShipyardDialog;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.OpenPatricianDialogInput;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.RowConstraints;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shipyardRenameDialog")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipyardRenameDialogV2
extends BaseShipyardDialog {
    @ObjectPropertyType(value=IShip.class)
    private ObjectProperty<IShip> currentShip = new SimpleObjectProperty((Object)this, "currentShip", null);
    private StringProperty shipName;
    private OpenPatricianDialogInput shipNameInput;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public ShipyardRenameDialogV2(ICityPlayerProxyJFX city) {
        super(city);
        if (city.getActiveShip() instanceof IShip) {
            IShip ship = (IShip)city.getActiveShip();
            this.currentShip.setValue((Object)ship);
        }
        String initialName = city.getActiveShip() != null ? city.getActiveShip().getName() : null;
        this.shipName = new SimpleStringProperty((Object)this, "shipName", initialName);
        if (this.currentShip.get() != null) {
            for (int i = 0; i < this.shipTypes.length; ++i) {
                if (this.shipTypes[i] != ((IShip)this.currentShip.get()).getShipType()) continue;
                this.currentShipTypeIndexProperty().set(i);
                break;
            }
        } else {
            this.currentShipTypeIndexProperty().set(0);
        }
    }

    @PostConstruct
    private void init() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardRenameDialogV2.title", new Object[0], this.locale.getCurrentLocal()));
        this.enablePreviousNext = this.dialogUtil.enableShipCatalogueForShips(this.city);
    }

    @Override
    protected String getActionText() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardRenameDialogV2.rename", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected boolean hasShips() {
        return this.city.getPlayersShips().size() > 0;
    }

    @Override
    protected EventHandler<MouseEvent> getAction() {
        return mouseEvent -> {
            ((IShip)this.currentShip.get()).setName((String)this.shipName.get());
            this.executeOnCloseButtonClicked();
        };
    }

    @Override
    protected Group createFooterText() {
        return new Group();
    }

    @Override
    protected Table createMainTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(2);
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{150, 200});
        TableRow row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardRenameDialogV2.shipName", new Object[0], this.locale.getCurrentLocal())));
        this.shipNameInput = new OpenPatricianDialogInput("");
        this.shipNameInput.getStyleClass().add((Object)"defaultLabelFont");
        this.shipNameInput.textProperty().bindBidirectional((Property)this.shipName);
        row.add((ITableCell)new ControlTableCell((Node)this.shipNameInput));
        model.add(row);
        return model;
    }

    @Override
    protected BooleanBinding actionEnabledBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return !((String)ShipyardRenameDialogV2.this.shipName.get()).equals(ShipyardRenameDialogV2.this.city.getActiveShip().getName());
            }
        };
    }

    @Override
    protected RowConstraints getRowConstraints() {
        return new RowConstraints(36.0);
    }

    @Override
    protected Table createTopTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(3);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{70, 70, 70});
        TableRow row = new TableRow();
        BarrelAmount capacityAmount = new BarrelAmount();
        capacityAmount.setAmount(Integer.valueOf(((IShip)this.currentShip.get()).getSize()));
        row.add((ITableCell)new ControlTableCell((Node)capacityAmount));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(100 - ((IShip)this.currentShip.get()).getDamage())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(((IShip)this.currentShip.get()).getNumberOfSailors())));
        model.add(row);
        return model;
    }

    @Override
    protected EventHandler<MouseEvent> createNextAction() {
        return this.dialogUtil.createNextActionForShips(this.city, this.currentShip);
    }

    @Override
    protected EventHandler<MouseEvent> createPreviousAction() {
        return this.dialogUtil.createPreviousActionForShips(this.city, this.currentShip);
    }
}

