/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernEscortDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    public TavernEscortDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getEscorte());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IEscorte escort = (IEscorte)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("destination", escort.getDestination().getName());
        parameters.put("price", escort.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            if ((IShip)this.city.getActiveShip() != null) {
                IEscorte escort = (IEscorte)this.currentPerson.get();
                IShip ship = (IShip)this.city.getActiveShip();
                ship.addPassenger((IPerson)escort);
                this.eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, escort.getDestination(), (IPlayer)this.city.getPlayer(), escort.getPremium());
                this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.acceptMessage", new Object[]{ship.getName()}));
                escort.leave();
                this.city.getPlayer().updateCrimialDrive(-1);
                this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){
            {
                if (TavernEscortDialog.this.city.getActiveShip() instanceof IShip) {
                    ((IShip)TavernEscortDialog.this.city.getActiveShip()).passengerPresentProperty();
                }
            }

            protected boolean computeValue() {
                return !(TavernEscortDialog.this.city.getActiveShip() instanceof IShip) || TavernEscortDialog.this.city.getPlayersShips().isEmpty() || ((IShip)TavernEscortDialog.this.city.getActiveShip()).passengerPresentProperty().get();
            }
        };
    }
}

