/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.gameplay.internal;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.gameplay.internal.ScenePolygonInitialzer;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class MarketScenePolygonInitializer
extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;

    public MarketScenePolygonInitializer() {
        super("images/scene/marketPlaceScene");
    }

    @Override
    protected EventHandler<MouseEvent> createEventHandler(String name) {
        switch (name) {
            case "MarketBooth": {
                return mouseEvent -> {
                    ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_MARKET_BOOTH);
                    this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                    this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                };
            }
            case "Floor": {
                return mouseEvent -> {
                    ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_PORT);
                    this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                    proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_HIDE);
                    this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                };
            }
            case "CityHall": {
                return mouseEvent -> {
                    ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_CITY_HALL);
                    this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                    proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_HIDE);
                    this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                };
            }
            case "Church": {
                return mouseEvent -> {
                    ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_CHURCH);
                    this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                    this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                };
            }
            case "Guild": {
                return mouseEvent -> {
                    ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_GUILD);
                    this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)proxy));
                    this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
                };
            }
        }
        throw new IllegalStateException("Unhandled polygon action: " + name);
    }
}

