/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.event.task;

import ch.sahits.game.graphic.event.task.IDelayedCaughtAction;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class DelayedCaughtAction
extends TimedTask
implements IDelayedCaughtAction {
    private final IPlayer player;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    public DelayedCaughtAction(IPlayer player) {
        this.player = player;
    }

    @PostConstruct
    private void initialize() {
        this.setExecutionTime(this.date.getCurrentDate().plusDays(5));
    }

    @Override
    public void run() {
        int penalty = (int)Math.abs((double)(this.player.getCompany().getCash() / 200L) * this.rnd.nextDouble());
        DisplayMessage msg = new DisplayMessage("ch.sahits.game.graphic.event.task.DelayedCaughtAction.message", new Object[]{penalty});
        this.clientEventBus.post((Object)msg);
        this.player.getCompany().updateCash((long)(-penalty));
    }
}

