/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class FinedTimedTask
extends TimedTask {
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    private final IHumanPlayer player;
    private final int fine;
    private final String messageKey;

    public FinedTimedTask(IHumanPlayer player, int fine, String messageKey, DateTime deadline) {
        this.player = player;
        this.fine = fine;
        this.messageKey = messageKey;
        this.setExecutionTime(deadline);
    }

    public void run() {
        DisplayMessage msg = new DisplayMessage(this.messageKey, new Object[]{this.fine});
        this.clientEventBus.post((Object)msg);
        this.player.getCompany().updateCash((long)(-this.fine));
    }
}

