/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WarehouseTentantLeaveTimedTask
extends TimedTask {
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    private ITradingOffice office;
    private IWarehouseTenant tenant;

    public WarehouseTentantLeaveTimedTask(ITradingOffice office, IWarehouseTenant tenant, DateTime dealine) {
        this.office = office;
        this.tenant = tenant;
        this.setExecutionTime(dealine);
    }

    public void run() {
        this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.graphic.display.dialog.TavernWarehouseTenantDialog.acceptMessage", new Object[0]));
        this.office.setOccupiedSpace(this.office.getOccupiedSpace() - this.tenant.getAmount());
    }
}

