/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NavigationStateChange;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.data.NoticeBoardPersistentClose;
import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.OpenPaticianApplicationWindow;
import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.scene.InGameOptionsScene;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.javafx.control.TogglebleImageButton;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.sound.ITrackPlayer;
import ch.sahits.game.util.UIFactory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.JAVAFX, EClassCategory.SINGLETON_BEAN})
public class MainMenu
extends Group {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private IDataImageLoader imageLoader;
    @Autowired
    private UIFactory uiFactory;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private ITrackPlayer soundPlayer;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    private boolean navigationDisabled = false;
    private SceneChangeable sceneChangeable;

    public MainMenu() {
        this.setManaged(false);
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
    }

    @PostConstruct
    private void initializeControls() {
        this.clientEventBus.register((Object)this);
        this.sceneChangeable = OpenPaticianApplicationWindow.getApplication();
        HBox iconBar = new HBox(2.0);
        Image inactiveMessagesIcon = this.imageLoader.getImage("icons/64/paperscrolls-icon");
        Image activeMessagesIcon = this.imageLoader.getImage("icons/64/paperscrolls-unfurled-icon");
        TogglebleImageButton messagesGraphic = new TogglebleImageButton(inactiveMessagesIcon, activeMessagesIcon);
        Label messages = new Label();
        messages.setGraphic((Node)messagesGraphic);
        messages.setScaleX(0.5);
        messages.setScaleY(0.5);
        messages.setOnMouseReleased(mouseEvent -> {
            if (!this.navigationDisabled) {
                ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MESSAGES);
                if (messagesGraphic.getActive()) {
                    NoticeBoardPersistentClose closeEvent = new NoticeBoardPersistentClose((ICityPlayerProxyJFX)proxy, EViewChangeEvent.MESSAGES);
                    this.clientEventBus.post((Object)closeEvent);
                } else {
                    NoticeBoardUpdate noticeBoardUpdate = new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy);
                    this.clientEventBus.post((Object)noticeBoardUpdate);
                }
                messagesGraphic.toggle();
            }
        });
        ImageView optionsGraphic = new ImageView(this.imageLoader.getImage("icons/64/anchor"));
        Label options = new Label();
        options.setGraphic((Node)optionsGraphic);
        options.setScaleX(0.5);
        options.setScaleY(0.5);
        options.setOnMouseReleased(mouseEvent -> {
            if (!this.navigationDisabled) {
                this.soundPlayer.stop();
                this.timerEventBus.post((Object)new PauseGame());
                InGameOptionsScene options1 = this.uiFactory.getInGameOptionsScene();
                options1.initializeState();
                options1.setSceneChangeable(this.sceneChangeable);
                this.sceneChangeable.changeScene(options1);
            }
        });
        iconBar.getChildren().addAll((Object[])new Node[]{messages, options});
        iconBar.setLayoutX(-12.0);
        iconBar.setLayoutY(-12.0);
        this.getChildren().addAll((Object[])new Node[]{iconBar});
    }

    @Subscribe
    public void handleNAvigationChange(NavigationStateChange event) {
        switch (event.getChange()) {
            case DISABLE_NAVIGATION: {
                this.navigationDisabled = true;
                break;
            }
            case ENABLE_NAVIGATION: {
                this.navigationDisabled = false;
                break;
            }
            default: {
                this.logger.info("Not interested in navigation change event: " + event.getChange());
            }
        }
    }
}

