/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.spring;

import ch.sahits.game.graphic.display.CheatKeyEventListener;
import ch.sahits.game.graphic.display.notice.OpenPatricianNoticeBoard;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.graphic.service.BezierPathConverter;
import ch.sahits.game.javafx.control.GameStatus;
import ch.sahits.game.javafx.control.MainMenu;
import ch.sahits.game.javafx.control.MiniMap;
import ch.sahits.game.javafx.control.SubMenu;
import ch.sahits.game.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.engine.sea.IPathConverter;
import ch.sahits.game.openpatrician.event.IEventPropagator;
import ch.sahits.game.openpatrician.server.events.StandaloneMessagePropagator;
import ch.sahits.game.openpatrician.spring.ClientServerInterfaceStandaloneConfiguration;
import ch.sahits.game.openpatrician.spring.DialogScope;
import ch.sahits.game.openpatrician.spring.ServerConfiguration;
import ch.sahits.game.openpatrician.spring.UICommonConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

@Configuration
@Import(value={ClientServerInterfaceStandaloneConfiguration.class, ServerConfiguration.class, UICommonConfiguration.class})
@ComponentScan(basePackages={"ch.sahits.game.event.handler"})
@ClassCategory(value={EClassCategory.STARTUP})
public class StandaloneConfiguration {
    @Bean
    public static DialogScope dialogScope() {
        return new DialogScope();
    }

    @Bean
    @Lazy
    public MiniMap miniMap() {
        return new MiniMap();
    }

    @Bean
    @Lazy
    public MainMenu mainMenu() {
        return new MainMenu();
    }

    @Bean
    @Lazy
    public SubMenu subMenu() {
        return new SubMenu();
    }

    @Bean
    @Lazy
    public OpenPatricianNoticeBoard noticeBoard() {
        OpenPatricianNoticeBoard bean = new OpenPatricianNoticeBoard();
        return bean;
    }

    @Bean
    @Lazy
    public ViewStatus viewStatus() {
        return new ViewStatus();
    }

    @Bean
    @Lazy
    public GameStatus gameStatus() {
        return new GameStatus();
    }

    @Bean
    @Scope(value="prototype")
    public MainGameView mainGameView(double width, double height) {
        return new MainGameView(width, height);
    }

    @Bean
    public IEventPropagator standaloneMessagePropagator() {
        return new StandaloneMessagePropagator();
    }

    @Bean
    @Lazy
    public IPathConverter pathConverter() {
        return new BezierPathConverter();
    }

    @Bean
    @Lazy
    public CheatKeyEventListener cheatModeKeyListener() {
        return new CheatKeyEventListener();
    }
}

