package ch.sahits.game.event.handler.impl;


import ch.sahits.game.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * The passenger leaves the ship when it arrives in the city and the player gets
 * a certain amount of money.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 19, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class PassengerLeavesShipOnArival extends ShipEntersPortEventListener {
	private final int premium;
	private final IPlayer shipsOwner;
	public PassengerLeavesShipOnArival(IShip ship, ICity city, IPlayer shipsOwner, int premium) {
		super(ship, city);
		this.premium = premium;
		this.shipsOwner = shipsOwner;
	}
    @PostConstruct
    private void initializeEventBus() {
        clientServerEventBus.register(this);
    }
	@PreDestroy
	private void unregisterEventBus() { clientServerEventBus.unregister(this);}
	@Override
	public boolean execute() {
		((IShip)getShip()).leavePassanger();
		shipsOwner.getCompany().updateCash(premium);
		unregisterEventBus();
		return true;
	}

}
