package ch.sahits.game.graphic.display.dialog.action;


import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.IWare;
import javafx.beans.property.SimpleIntegerProperty;

import java.util.Optional;

/**
 * This action handles the selling of wares from the storage to the city.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
@ClassCategory(EClassCategory.HANDLER)
class Storage2CityJFXAction implements Runnable {
	private final IWare ware;
	private final ITransferableJFX transfer;
//	private static final Logger logger = Logger.getLogger(Storage2CityAction.class.getName());

	public Storage2CityJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer=transfer;
	}

	@Override
	public void run() {
		Optional<ITradingOffice> optOffice = transfer.getPlayer().findTradingOffice(transfer.getCity());
		if (optOffice.isPresent()) {
			ITradingOffice office = optOffice.get();
			int amountInStorage = office.getWare(ware).getAmount();
			if (amountInStorage > 0) {
				int availableAmountCity = transfer.getCity().getWare(ware).getAmount();
				int amount2Move = transfer.getAmount(amountInStorage);
				final int avgPrice;
				if (transfer.getMovableAmount() == ETransferAmount.MAX) {
					avgPrice = ware.getMaxValueSell();
				} else {
					ComputablePriceV2 computablePrice = new ComputablePriceV2();
					avgPrice = computablePrice.sellPrice(ware, new SimpleIntegerProperty(availableAmountCity), new ConstantIntegerBinding(amount2Move));
				}
				transfer.getCity().move(ware, amount2Move,transfer.getPlayer()); // The price here is irrelevant
				int sold = office.move(ware, -amount2Move);
				transfer.getPlayer().getCompany().updateCash(avgPrice * sold);
			} // end stored amount
		} // end office 
	}
	
}
