package ch.sahits.game.graphic.display.dialog.event;

import ch.sahits.game.graphic.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.CelebrationState;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * Dialog to inform on the success of a celebration.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 08, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class CelebrationDialog extends DefaultSimpleDialog {
    private final CelebrationState state;
    @Autowired
    private ModelTranslations modelTranslations;

    public CelebrationDialog(CelebrationState state) {
        super(true);
        this.state = state;
    }
    @PostConstruct
    private void initializeDialog() {
        String letterDate = modelTranslations.toDisplayString(state.getDate());

        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation(), letterDate);
        addVerticalSpacer(20);
        String key = "ch.sahits.game.graphic.display.dialog.event.CelebrationDialog." + state.getSuccess();
        addDecoratedText(key, "message", state.getAmountGuests());
    }
}
