package ch.sahits.game.graphic.display.dialog.event;

import ch.sahits.game.graphic.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.DowryState;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * Dialog informing about the dowry.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 10, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class DowryDialog extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;

    private final DowryState state;

    public DowryDialog(DowryState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = modelTranslations.toDisplayString(state.getDate());
        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation(), letterDate);
        addVerticalSpacer(20);
        IShip ship = state.getShip();
        int loaded = ship.getLoadBinding().get();
        String shipType = modelTranslations.getLocalDisplayName(ship.getShipType());
        if (loaded > 0) {
            addDecoratedText("ch.sahits.game.graphic.display.dialog.event.DowryDialog.dowry.filled", "dowryWithLoad", shipType, loaded);
        } else {
            addDecoratedText("ch.sahits.game.graphic.display.dialog.event.DowryDialog.dowry.empty", "dowryWithoutLoad", shipType);
        }

    }
}