package ch.sahits.game.graphic.display.dialog.event;

import ch.sahits.game.graphic.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.FireState;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * Dialog displaying the information of a fire.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 11, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class FireDialog extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    private FireState state;

    public FireDialog(FireState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = modelTranslations.toDisplayString(state.getDate());
        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation(), letterDate);
        addVerticalSpacer(20);
        addDecoratedText("ch.sahits.game.graphic.display.dialog.event.FireDialog.fire", "fire", state.getLocation(), state.getDestroyedBuildings(), state.getDeathtoll());
        if (state.getKilledSpouse().isPresent()) {
            ISpouseData spouse = state.getKilledSpouse().get();
            addDecoratedText("ch.sahits.game.graphic.display.dialog.event.FireDialog.wiveDeath", "wiveDeath", spouse.getName(), spouse.getLastName());
        }
    }
}
