package ch.sahits.game.graphic.display.dialog.event;

import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.graphic.event.task.MarriageOfferTimedTask;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import javafx.geometry.Pos;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.Random;

/**
 * Dialog for displaying a marraiage contract broker offer.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 06, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class MarriageBrokerAnnouncementDialog extends DefaultSimpleDialog {
    private final MarriageBrokerAnnouncementState state;
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private DateService dateService;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private Random rnd;
    @Autowired
    private ClientViewState clientViewState;
    @Autowired
    private ClientTaskFactory taskFactory;


    public MarriageBrokerAnnouncementDialog(MarriageBrokerAnnouncementState state) {
        super(true);
        this.state = state;
    }
    @PostConstruct
    private void initializeDialog() {
        String date = modelTranslations.toDisplayString(state.getDate());
        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation(), date);
        addVerticalSpacer(20);
        if (state.isGenderMale()) {
            addDecoratedText("letter.salutation.male", "salutationMale", state.getToLastName());
        } else {
            addDecoratedText("letter.salutation.female", "salutationFemale", state.getToLastName());
        }
        addVerticalSpacer(20);
        if (state.isGenderMale()) {
            addDecoratedText("ch.sahits.game.graphic.display.dialog.event.MarriageBrokerAnnouncementDialog.content.male", "contentMale");
        } else {
            addDecoratedText("ch.sahits.game.graphic.display.dialog.event.MarriageBrokerAnnouncementDialog.content.female", "contentFemale");
        }
        addVerticalSpacer(20);
        addDecoratedText("letter.feedback.14d", "deadline");
        addVerticalSpacer(20);
        addDecoratedText("letter.greetings", "grettings", Pos.CENTER);
        addDecoratedText("letter.fullname", "signature", Pos.CENTER_RIGHT, state.getFromFirstName(), state.getFromLastName());
        DateTime decisionDeadline = state.getDate().plusDays(14);
        if (!dateService.isPast(decisionDeadline)) {
            OpenPatricianLargeWaxButton button = addActionButton("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.accept", "acceptBtn");
            button.setOnAction(event -> {
                int delay = rnd.nextInt(50) + 24;
                DateTime deadLine = state.getDate().plusDays(delay);
                MarriageOfferTimedTask task = taskFactory.getMarriageOfferTask(clientViewState.getPlayer(), state, deadLine);
                taskList.add(task);
            });
        }
    }

}
